// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/bigquery/v2/model.proto

package bigquery

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Indicates the type of the Model.
type Model_ModelType int32

const (
	Model_MODEL_TYPE_UNSPECIFIED Model_ModelType = 0
	// Linear regression model.
	Model_LINEAR_REGRESSION Model_ModelType = 1
	// Logistic regression based classification model.
	Model_LOGISTIC_REGRESSION Model_ModelType = 2
	// K-means clustering model.
	Model_KMEANS Model_ModelType = 3
	// Matrix factorization model.
	Model_MATRIX_FACTORIZATION Model_ModelType = 4
	// [Beta] DNN classifier model.
	Model_DNN_CLASSIFIER Model_ModelType = 5
	// [Beta] An imported TensorFlow model.
	Model_TENSORFLOW Model_ModelType = 6
	// [Beta] DNN regressor model.
	Model_DNN_REGRESSOR Model_ModelType = 7
	// [Beta] Boosted tree regressor model.
	Model_BOOSTED_TREE_REGRESSOR Model_ModelType = 9
	// [Beta] Boosted tree classifier model.
	Model_BOOSTED_TREE_CLASSIFIER Model_ModelType = 10
	// [Beta] ARIMA model.
	Model_ARIMA Model_ModelType = 11
	// [Beta] AutoML Tables regression model.
	Model_AUTOML_REGRESSOR Model_ModelType = 12
	// [Beta] AutoML Tables classification model.
	Model_AUTOML_CLASSIFIER Model_ModelType = 13
)

// Enum value maps for Model_ModelType.
var (
	Model_ModelType_name = map[int32]string{
		0:  "MODEL_TYPE_UNSPECIFIED",
		1:  "LINEAR_REGRESSION",
		2:  "LOGISTIC_REGRESSION",
		3:  "KMEANS",
		4:  "MATRIX_FACTORIZATION",
		5:  "DNN_CLASSIFIER",
		6:  "TENSORFLOW",
		7:  "DNN_REGRESSOR",
		9:  "BOOSTED_TREE_REGRESSOR",
		10: "BOOSTED_TREE_CLASSIFIER",
		11: "ARIMA",
		12: "AUTOML_REGRESSOR",
		13: "AUTOML_CLASSIFIER",
	}
	Model_ModelType_value = map[string]int32{
		"MODEL_TYPE_UNSPECIFIED":  0,
		"LINEAR_REGRESSION":       1,
		"LOGISTIC_REGRESSION":     2,
		"KMEANS":                  3,
		"MATRIX_FACTORIZATION":    4,
		"DNN_CLASSIFIER":          5,
		"TENSORFLOW":              6,
		"DNN_REGRESSOR":           7,
		"BOOSTED_TREE_REGRESSOR":  9,
		"BOOSTED_TREE_CLASSIFIER": 10,
		"ARIMA":                   11,
		"AUTOML_REGRESSOR":        12,
		"AUTOML_CLASSIFIER":       13,
	}
)

func (x Model_ModelType) Enum() *Model_ModelType {
	p := new(Model_ModelType)
	*p = x
	return p
}

func (x Model_ModelType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Model_ModelType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_v2_model_proto_enumTypes[0].Descriptor()
}

func (Model_ModelType) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_v2_model_proto_enumTypes[0]
}

func (x Model_ModelType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Model_ModelType.Descriptor instead.
func (Model_ModelType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 0}
}

// Loss metric to evaluate model training performance.
type Model_LossType int32

const (
	Model_LOSS_TYPE_UNSPECIFIED Model_LossType = 0
	// Mean squared loss, used for linear regression.
	Model_MEAN_SQUARED_LOSS Model_LossType = 1
	// Mean log loss, used for logistic regression.
	Model_MEAN_LOG_LOSS Model_LossType = 2
)

// Enum value maps for Model_LossType.
var (
	Model_LossType_name = map[int32]string{
		0: "LOSS_TYPE_UNSPECIFIED",
		1: "MEAN_SQUARED_LOSS",
		2: "MEAN_LOG_LOSS",
	}
	Model_LossType_value = map[string]int32{
		"LOSS_TYPE_UNSPECIFIED": 0,
		"MEAN_SQUARED_LOSS":     1,
		"MEAN_LOG_LOSS":         2,
	}
)

func (x Model_LossType) Enum() *Model_LossType {
	p := new(Model_LossType)
	*p = x
	return p
}

func (x Model_LossType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Model_LossType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_v2_model_proto_enumTypes[1].Descriptor()
}

func (Model_LossType) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_v2_model_proto_enumTypes[1]
}

func (x Model_LossType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Model_LossType.Descriptor instead.
func (Model_LossType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 1}
}

// Distance metric used to compute the distance between two points.
type Model_DistanceType int32

const (
	Model_DISTANCE_TYPE_UNSPECIFIED Model_DistanceType = 0
	// Eculidean distance.
	Model_EUCLIDEAN Model_DistanceType = 1
	// Cosine distance.
	Model_COSINE Model_DistanceType = 2
)

// Enum value maps for Model_DistanceType.
var (
	Model_DistanceType_name = map[int32]string{
		0: "DISTANCE_TYPE_UNSPECIFIED",
		1: "EUCLIDEAN",
		2: "COSINE",
	}
	Model_DistanceType_value = map[string]int32{
		"DISTANCE_TYPE_UNSPECIFIED": 0,
		"EUCLIDEAN":                 1,
		"COSINE":                    2,
	}
)

func (x Model_DistanceType) Enum() *Model_DistanceType {
	p := new(Model_DistanceType)
	*p = x
	return p
}

func (x Model_DistanceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Model_DistanceType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_v2_model_proto_enumTypes[2].Descriptor()
}

func (Model_DistanceType) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_v2_model_proto_enumTypes[2]
}

func (x Model_DistanceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Model_DistanceType.Descriptor instead.
func (Model_DistanceType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 2}
}

// Indicates the method to split input data into multiple tables.
type Model_DataSplitMethod int32

const (
	Model_DATA_SPLIT_METHOD_UNSPECIFIED Model_DataSplitMethod = 0
	// Splits data randomly.
	Model_RANDOM Model_DataSplitMethod = 1
	// Splits data with the user provided tags.
	Model_CUSTOM Model_DataSplitMethod = 2
	// Splits data sequentially.
	Model_SEQUENTIAL Model_DataSplitMethod = 3
	// Data split will be skipped.
	Model_NO_SPLIT Model_DataSplitMethod = 4
	// Splits data automatically: Uses NO_SPLIT if the data size is small.
	// Otherwise uses RANDOM.
	Model_AUTO_SPLIT Model_DataSplitMethod = 5
)

// Enum value maps for Model_DataSplitMethod.
var (
	Model_DataSplitMethod_name = map[int32]string{
		0: "DATA_SPLIT_METHOD_UNSPECIFIED",
		1: "RANDOM",
		2: "CUSTOM",
		3: "SEQUENTIAL",
		4: "NO_SPLIT",
		5: "AUTO_SPLIT",
	}
	Model_DataSplitMethod_value = map[string]int32{
		"DATA_SPLIT_METHOD_UNSPECIFIED": 0,
		"RANDOM":                        1,
		"CUSTOM":                        2,
		"SEQUENTIAL":                    3,
		"NO_SPLIT":                      4,
		"AUTO_SPLIT":                    5,
	}
)

func (x Model_DataSplitMethod) Enum() *Model_DataSplitMethod {
	p := new(Model_DataSplitMethod)
	*p = x
	return p
}

func (x Model_DataSplitMethod) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Model_DataSplitMethod) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_v2_model_proto_enumTypes[3].Descriptor()
}

func (Model_DataSplitMethod) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_v2_model_proto_enumTypes[3]
}

func (x Model_DataSplitMethod) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Model_DataSplitMethod.Descriptor instead.
func (Model_DataSplitMethod) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 3}
}

// Type of supported data frequency for time series forecasting models.
type Model_DataFrequency int32

const (
	Model_DATA_FREQUENCY_UNSPECIFIED Model_DataFrequency = 0
	// Automatically inferred from timestamps.
	Model_AUTO_FREQUENCY Model_DataFrequency = 1
	// Yearly data.
	Model_YEARLY Model_DataFrequency = 2
	// Quarterly data.
	Model_QUARTERLY Model_DataFrequency = 3
	// Monthly data.
	Model_MONTHLY Model_DataFrequency = 4
	// Weekly data.
	Model_WEEKLY Model_DataFrequency = 5
	// Daily data.
	Model_DAILY Model_DataFrequency = 6
	// Hourly data.
	Model_HOURLY Model_DataFrequency = 7
)

// Enum value maps for Model_DataFrequency.
var (
	Model_DataFrequency_name = map[int32]string{
		0: "DATA_FREQUENCY_UNSPECIFIED",
		1: "AUTO_FREQUENCY",
		2: "YEARLY",
		3: "QUARTERLY",
		4: "MONTHLY",
		5: "WEEKLY",
		6: "DAILY",
		7: "HOURLY",
	}
	Model_DataFrequency_value = map[string]int32{
		"DATA_FREQUENCY_UNSPECIFIED": 0,
		"AUTO_FREQUENCY":             1,
		"YEARLY":                     2,
		"QUARTERLY":                  3,
		"MONTHLY":                    4,
		"WEEKLY":                     5,
		"DAILY":                      6,
		"HOURLY":                     7,
	}
)

func (x Model_DataFrequency) Enum() *Model_DataFrequency {
	p := new(Model_DataFrequency)
	*p = x
	return p
}

func (x Model_DataFrequency) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Model_DataFrequency) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_v2_model_proto_enumTypes[4].Descriptor()
}

func (Model_DataFrequency) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_v2_model_proto_enumTypes[4]
}

func (x Model_DataFrequency) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Model_DataFrequency.Descriptor instead.
func (Model_DataFrequency) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 4}
}

// Type of supported holiday regions for time series forecasting models.
type Model_HolidayRegion int32

const (
	// Holiday region unspecified.
	Model_HOLIDAY_REGION_UNSPECIFIED Model_HolidayRegion = 0
	// Global.
	Model_GLOBAL Model_HolidayRegion = 1
	// North America.
	Model_NA Model_HolidayRegion = 2
	// Japan and Asia Pacific: Korea, Greater China, India, Australia, and New
	// Zealand.
	Model_JAPAC Model_HolidayRegion = 3
	// Europe, the Middle East and Africa.
	Model_EMEA Model_HolidayRegion = 4
	// Latin America and the Caribbean.
	Model_LAC Model_HolidayRegion = 5
	// United Arab Emirates
	Model_AE Model_HolidayRegion = 6
	// Argentina
	Model_AR Model_HolidayRegion = 7
	// Austria
	Model_AT Model_HolidayRegion = 8
	// Australia
	Model_AU Model_HolidayRegion = 9
	// Belgium
	Model_BE Model_HolidayRegion = 10
	// Brazil
	Model_BR Model_HolidayRegion = 11
	// Canada
	Model_CA Model_HolidayRegion = 12
	// Switzerland
	Model_CH Model_HolidayRegion = 13
	// Chile
	Model_CL Model_HolidayRegion = 14
	// China
	Model_CN Model_HolidayRegion = 15
	// Colombia
	Model_CO Model_HolidayRegion = 16
	// Czechoslovakia
	Model_CS Model_HolidayRegion = 17
	// Czech Republic
	Model_CZ Model_HolidayRegion = 18
	// Germany
	Model_DE Model_HolidayRegion = 19
	// Denmark
	Model_DK Model_HolidayRegion = 20
	// Algeria
	Model_DZ Model_HolidayRegion = 21
	// Ecuador
	Model_EC Model_HolidayRegion = 22
	// Estonia
	Model_EE Model_HolidayRegion = 23
	// Egypt
	Model_EG Model_HolidayRegion = 24
	// Spain
	Model_ES Model_HolidayRegion = 25
	// Finland
	Model_FI Model_HolidayRegion = 26
	// France
	Model_FR Model_HolidayRegion = 27
	// Great Britain (United Kingdom)
	Model_GB Model_HolidayRegion = 28
	// Greece
	Model_GR Model_HolidayRegion = 29
	// Hong Kong
	Model_HK Model_HolidayRegion = 30
	// Hungary
	Model_HU Model_HolidayRegion = 31
	// Indonesia
	Model_ID Model_HolidayRegion = 32
	// Ireland
	Model_IE Model_HolidayRegion = 33
	// Israel
	Model_IL Model_HolidayRegion = 34
	// India
	Model_IN Model_HolidayRegion = 35
	// Iran
	Model_IR Model_HolidayRegion = 36
	// Italy
	Model_IT Model_HolidayRegion = 37
	// Japan
	Model_JP Model_HolidayRegion = 38
	// Korea (South)
	Model_KR Model_HolidayRegion = 39
	// Latvia
	Model_LV Model_HolidayRegion = 40
	// Morocco
	Model_MA Model_HolidayRegion = 41
	// Mexico
	Model_MX Model_HolidayRegion = 42
	// Malaysia
	Model_MY Model_HolidayRegion = 43
	// Nigeria
	Model_NG Model_HolidayRegion = 44
	// Netherlands
	Model_NL Model_HolidayRegion = 45
	// Norway
	Model_NO Model_HolidayRegion = 46
	// New Zealand
	Model_NZ Model_HolidayRegion = 47
	// Peru
	Model_PE Model_HolidayRegion = 48
	// Philippines
	Model_PH Model_HolidayRegion = 49
	// Pakistan
	Model_PK Model_HolidayRegion = 50
	// Poland
	Model_PL Model_HolidayRegion = 51
	// Portugal
	Model_PT Model_HolidayRegion = 52
	// Romania
	Model_RO Model_HolidayRegion = 53
	// Serbia
	Model_RS Model_HolidayRegion = 54
	// Russian Federation
	Model_RU Model_HolidayRegion = 55
	// Saudi Arabia
	Model_SA Model_HolidayRegion = 56
	// Sweden
	Model_SE Model_HolidayRegion = 57
	// Singapore
	Model_SG Model_HolidayRegion = 58
	// Slovenia
	Model_SI Model_HolidayRegion = 59
	// Slovakia
	Model_SK Model_HolidayRegion = 60
	// Thailand
	Model_TH Model_HolidayRegion = 61
	// Turkey
	Model_TR Model_HolidayRegion = 62
	// Taiwan
	Model_TW Model_HolidayRegion = 63
	// Ukraine
	Model_UA Model_HolidayRegion = 64
	// United States
	Model_US Model_HolidayRegion = 65
	// Venezuela
	Model_VE Model_HolidayRegion = 66
	// Viet Nam
	Model_VN Model_HolidayRegion = 67
	// South Africa
	Model_ZA Model_HolidayRegion = 68
)

// Enum value maps for Model_HolidayRegion.
var (
	Model_HolidayRegion_name = map[int32]string{
		0:  "HOLIDAY_REGION_UNSPECIFIED",
		1:  "GLOBAL",
		2:  "NA",
		3:  "JAPAC",
		4:  "EMEA",
		5:  "LAC",
		6:  "AE",
		7:  "AR",
		8:  "AT",
		9:  "AU",
		10: "BE",
		11: "BR",
		12: "CA",
		13: "CH",
		14: "CL",
		15: "CN",
		16: "CO",
		17: "CS",
		18: "CZ",
		19: "DE",
		20: "DK",
		21: "DZ",
		22: "EC",
		23: "EE",
		24: "EG",
		25: "ES",
		26: "FI",
		27: "FR",
		28: "GB",
		29: "GR",
		30: "HK",
		31: "HU",
		32: "ID",
		33: "IE",
		34: "IL",
		35: "IN",
		36: "IR",
		37: "IT",
		38: "JP",
		39: "KR",
		40: "LV",
		41: "MA",
		42: "MX",
		43: "MY",
		44: "NG",
		45: "NL",
		46: "NO",
		47: "NZ",
		48: "PE",
		49: "PH",
		50: "PK",
		51: "PL",
		52: "PT",
		53: "RO",
		54: "RS",
		55: "RU",
		56: "SA",
		57: "SE",
		58: "SG",
		59: "SI",
		60: "SK",
		61: "TH",
		62: "TR",
		63: "TW",
		64: "UA",
		65: "US",
		66: "VE",
		67: "VN",
		68: "ZA",
	}
	Model_HolidayRegion_value = map[string]int32{
		"HOLIDAY_REGION_UNSPECIFIED": 0,
		"GLOBAL":                     1,
		"NA":                         2,
		"JAPAC":                      3,
		"EMEA":                       4,
		"LAC":                        5,
		"AE":                         6,
		"AR":                         7,
		"AT":                         8,
		"AU":                         9,
		"BE":                         10,
		"BR":                         11,
		"CA":                         12,
		"CH":                         13,
		"CL":                         14,
		"CN":                         15,
		"CO":                         16,
		"CS":                         17,
		"CZ":                         18,
		"DE":                         19,
		"DK":                         20,
		"DZ":                         21,
		"EC":                         22,
		"EE":                         23,
		"EG":                         24,
		"ES":                         25,
		"FI":                         26,
		"FR":                         27,
		"GB":                         28,
		"GR":                         29,
		"HK":                         30,
		"HU":                         31,
		"ID":                         32,
		"IE":                         33,
		"IL":                         34,
		"IN":                         35,
		"IR":                         36,
		"IT":                         37,
		"JP":                         38,
		"KR":                         39,
		"LV":                         40,
		"MA":                         41,
		"MX":                         42,
		"MY":                         43,
		"NG":                         44,
		"NL":                         45,
		"NO":                         46,
		"NZ":                         47,
		"PE":                         48,
		"PH":                         49,
		"PK":                         50,
		"PL":                         51,
		"PT":                         52,
		"RO":                         53,
		"RS":                         54,
		"RU":                         55,
		"SA":                         56,
		"SE":                         57,
		"SG":                         58,
		"SI":                         59,
		"SK":                         60,
		"TH":                         61,
		"TR":                         62,
		"TW":                         63,
		"UA":                         64,
		"US":                         65,
		"VE":                         66,
		"VN":                         67,
		"ZA":                         68,
	}
)

func (x Model_HolidayRegion) Enum() *Model_HolidayRegion {
	p := new(Model_HolidayRegion)
	*p = x
	return p
}

func (x Model_HolidayRegion) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Model_HolidayRegion) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_v2_model_proto_enumTypes[5].Descriptor()
}

func (Model_HolidayRegion) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_v2_model_proto_enumTypes[5]
}

func (x Model_HolidayRegion) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Model_HolidayRegion.Descriptor instead.
func (Model_HolidayRegion) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 5}
}

// Indicates the learning rate optimization strategy to use.
type Model_LearnRateStrategy int32

const (
	Model_LEARN_RATE_STRATEGY_UNSPECIFIED Model_LearnRateStrategy = 0
	// Use line search to determine learning rate.
	Model_LINE_SEARCH Model_LearnRateStrategy = 1
	// Use a constant learning rate.
	Model_CONSTANT Model_LearnRateStrategy = 2
)

// Enum value maps for Model_LearnRateStrategy.
var (
	Model_LearnRateStrategy_name = map[int32]string{
		0: "LEARN_RATE_STRATEGY_UNSPECIFIED",
		1: "LINE_SEARCH",
		2: "CONSTANT",
	}
	Model_LearnRateStrategy_value = map[string]int32{
		"LEARN_RATE_STRATEGY_UNSPECIFIED": 0,
		"LINE_SEARCH":                     1,
		"CONSTANT":                        2,
	}
)

func (x Model_LearnRateStrategy) Enum() *Model_LearnRateStrategy {
	p := new(Model_LearnRateStrategy)
	*p = x
	return p
}

func (x Model_LearnRateStrategy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Model_LearnRateStrategy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_v2_model_proto_enumTypes[6].Descriptor()
}

func (Model_LearnRateStrategy) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_v2_model_proto_enumTypes[6]
}

func (x Model_LearnRateStrategy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Model_LearnRateStrategy.Descriptor instead.
func (Model_LearnRateStrategy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 6}
}

// Indicates the optimization strategy used for training.
type Model_OptimizationStrategy int32

const (
	Model_OPTIMIZATION_STRATEGY_UNSPECIFIED Model_OptimizationStrategy = 0
	// Uses an iterative batch gradient descent algorithm.
	Model_BATCH_GRADIENT_DESCENT Model_OptimizationStrategy = 1
	// Uses a normal equation to solve linear regression problem.
	Model_NORMAL_EQUATION Model_OptimizationStrategy = 2
)

// Enum value maps for Model_OptimizationStrategy.
var (
	Model_OptimizationStrategy_name = map[int32]string{
		0: "OPTIMIZATION_STRATEGY_UNSPECIFIED",
		1: "BATCH_GRADIENT_DESCENT",
		2: "NORMAL_EQUATION",
	}
	Model_OptimizationStrategy_value = map[string]int32{
		"OPTIMIZATION_STRATEGY_UNSPECIFIED": 0,
		"BATCH_GRADIENT_DESCENT":            1,
		"NORMAL_EQUATION":                   2,
	}
)

func (x Model_OptimizationStrategy) Enum() *Model_OptimizationStrategy {
	p := new(Model_OptimizationStrategy)
	*p = x
	return p
}

func (x Model_OptimizationStrategy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Model_OptimizationStrategy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_v2_model_proto_enumTypes[7].Descriptor()
}

func (Model_OptimizationStrategy) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_v2_model_proto_enumTypes[7]
}

func (x Model_OptimizationStrategy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Model_OptimizationStrategy.Descriptor instead.
func (Model_OptimizationStrategy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 7}
}

// Indicates the training algorithm to use for matrix factorization models.
type Model_FeedbackType int32

const (
	Model_FEEDBACK_TYPE_UNSPECIFIED Model_FeedbackType = 0
	// Use weighted-als for implicit feedback problems.
	Model_IMPLICIT Model_FeedbackType = 1
	// Use nonweighted-als for explicit feedback problems.
	Model_EXPLICIT Model_FeedbackType = 2
)

// Enum value maps for Model_FeedbackType.
var (
	Model_FeedbackType_name = map[int32]string{
		0: "FEEDBACK_TYPE_UNSPECIFIED",
		1: "IMPLICIT",
		2: "EXPLICIT",
	}
	Model_FeedbackType_value = map[string]int32{
		"FEEDBACK_TYPE_UNSPECIFIED": 0,
		"IMPLICIT":                  1,
		"EXPLICIT":                  2,
	}
)

func (x Model_FeedbackType) Enum() *Model_FeedbackType {
	p := new(Model_FeedbackType)
	*p = x
	return p
}

func (x Model_FeedbackType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Model_FeedbackType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_v2_model_proto_enumTypes[8].Descriptor()
}

func (Model_FeedbackType) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_v2_model_proto_enumTypes[8]
}

func (x Model_FeedbackType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Model_FeedbackType.Descriptor instead.
func (Model_FeedbackType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 8}
}

type Model_SeasonalPeriod_SeasonalPeriodType int32

const (
	Model_SeasonalPeriod_SEASONAL_PERIOD_TYPE_UNSPECIFIED Model_SeasonalPeriod_SeasonalPeriodType = 0
	// No seasonality
	Model_SeasonalPeriod_NO_SEASONALITY Model_SeasonalPeriod_SeasonalPeriodType = 1
	// Daily period, 24 hours.
	Model_SeasonalPeriod_DAILY Model_SeasonalPeriod_SeasonalPeriodType = 2
	// Weekly period, 7 days.
	Model_SeasonalPeriod_WEEKLY Model_SeasonalPeriod_SeasonalPeriodType = 3
	// Monthly period, 30 days or irregular.
	Model_SeasonalPeriod_MONTHLY Model_SeasonalPeriod_SeasonalPeriodType = 4
	// Quarterly period, 90 days or irregular.
	Model_SeasonalPeriod_QUARTERLY Model_SeasonalPeriod_SeasonalPeriodType = 5
	// Yearly period, 365 days or irregular.
	Model_SeasonalPeriod_YEARLY Model_SeasonalPeriod_SeasonalPeriodType = 6
)

// Enum value maps for Model_SeasonalPeriod_SeasonalPeriodType.
var (
	Model_SeasonalPeriod_SeasonalPeriodType_name = map[int32]string{
		0: "SEASONAL_PERIOD_TYPE_UNSPECIFIED",
		1: "NO_SEASONALITY",
		2: "DAILY",
		3: "WEEKLY",
		4: "MONTHLY",
		5: "QUARTERLY",
		6: "YEARLY",
	}
	Model_SeasonalPeriod_SeasonalPeriodType_value = map[string]int32{
		"SEASONAL_PERIOD_TYPE_UNSPECIFIED": 0,
		"NO_SEASONALITY":                   1,
		"DAILY":                            2,
		"WEEKLY":                           3,
		"MONTHLY":                          4,
		"QUARTERLY":                        5,
		"YEARLY":                           6,
	}
)

func (x Model_SeasonalPeriod_SeasonalPeriodType) Enum() *Model_SeasonalPeriod_SeasonalPeriodType {
	p := new(Model_SeasonalPeriod_SeasonalPeriodType)
	*p = x
	return p
}

func (x Model_SeasonalPeriod_SeasonalPeriodType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Model_SeasonalPeriod_SeasonalPeriodType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_v2_model_proto_enumTypes[9].Descriptor()
}

func (Model_SeasonalPeriod_SeasonalPeriodType) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_v2_model_proto_enumTypes[9]
}

func (x Model_SeasonalPeriod_SeasonalPeriodType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Model_SeasonalPeriod_SeasonalPeriodType.Descriptor instead.
func (Model_SeasonalPeriod_SeasonalPeriodType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 0, 0}
}

// Indicates the method used to initialize the centroids for KMeans
// clustering algorithm.
type Model_KmeansEnums_KmeansInitializationMethod int32

const (
	Model_KmeansEnums_KMEANS_INITIALIZATION_METHOD_UNSPECIFIED Model_KmeansEnums_KmeansInitializationMethod = 0
	// Initializes the centroids randomly.
	Model_KmeansEnums_RANDOM Model_KmeansEnums_KmeansInitializationMethod = 1
	// Initializes the centroids using data specified in
	// kmeans_initialization_column.
	Model_KmeansEnums_CUSTOM Model_KmeansEnums_KmeansInitializationMethod = 2
	// Initializes with kmeans++.
	Model_KmeansEnums_KMEANS_PLUS_PLUS Model_KmeansEnums_KmeansInitializationMethod = 3
)

// Enum value maps for Model_KmeansEnums_KmeansInitializationMethod.
var (
	Model_KmeansEnums_KmeansInitializationMethod_name = map[int32]string{
		0: "KMEANS_INITIALIZATION_METHOD_UNSPECIFIED",
		1: "RANDOM",
		2: "CUSTOM",
		3: "KMEANS_PLUS_PLUS",
	}
	Model_KmeansEnums_KmeansInitializationMethod_value = map[string]int32{
		"KMEANS_INITIALIZATION_METHOD_UNSPECIFIED": 0,
		"RANDOM":           1,
		"CUSTOM":           2,
		"KMEANS_PLUS_PLUS": 3,
	}
)

func (x Model_KmeansEnums_KmeansInitializationMethod) Enum() *Model_KmeansEnums_KmeansInitializationMethod {
	p := new(Model_KmeansEnums_KmeansInitializationMethod)
	*p = x
	return p
}

func (x Model_KmeansEnums_KmeansInitializationMethod) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Model_KmeansEnums_KmeansInitializationMethod) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_v2_model_proto_enumTypes[10].Descriptor()
}

func (Model_KmeansEnums_KmeansInitializationMethod) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_v2_model_proto_enumTypes[10]
}

func (x Model_KmeansEnums_KmeansInitializationMethod) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Model_KmeansEnums_KmeansInitializationMethod.Descriptor instead.
func (Model_KmeansEnums_KmeansInitializationMethod) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 1, 0}
}

type Model struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. A hash of this resource.
	Etag string `protobuf:"bytes,1,opt,name=etag,proto3" json:"etag,omitempty"`
	// Required. Unique identifier for this model.
	ModelReference *ModelReference `protobuf:"bytes,2,opt,name=model_reference,json=modelReference,proto3" json:"model_reference,omitempty"`
	// Output only. The time when this model was created, in millisecs since the epoch.
	CreationTime int64 `protobuf:"varint,5,opt,name=creation_time,json=creationTime,proto3" json:"creation_time,omitempty"`
	// Output only. The time when this model was last modified, in millisecs since the epoch.
	LastModifiedTime int64 `protobuf:"varint,6,opt,name=last_modified_time,json=lastModifiedTime,proto3" json:"last_modified_time,omitempty"`
	// Optional. A user-friendly description of this model.
	Description string `protobuf:"bytes,12,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. A descriptive name for this model.
	FriendlyName string `protobuf:"bytes,14,opt,name=friendly_name,json=friendlyName,proto3" json:"friendly_name,omitempty"`
	// The labels associated with this model. You can use these to organize
	// and group your models. Label keys and values can be no longer
	// than 63 characters, can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	// Label values are optional. Label keys must start with a letter and each
	// label in the list must have a different key.
	Labels map[string]string `protobuf:"bytes,15,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. The time when this model expires, in milliseconds since the epoch.
	// If not present, the model will persist indefinitely. Expired models
	// will be deleted and their storage reclaimed.  The defaultTableExpirationMs
	// property of the encapsulating dataset can be used to set a default
	// expirationTime on newly created models.
	ExpirationTime int64 `protobuf:"varint,16,opt,name=expiration_time,json=expirationTime,proto3" json:"expiration_time,omitempty"`
	// Output only. The geographic location where the model resides. This value
	// is inherited from the dataset.
	Location string `protobuf:"bytes,13,opt,name=location,proto3" json:"location,omitempty"`
	// Custom encryption configuration (e.g., Cloud KMS keys). This shows the
	// encryption configuration of the model data while stored in BigQuery
	// storage. This field can be used with PatchModel to update encryption key
	// for an already encrypted model.
	EncryptionConfiguration *EncryptionConfiguration `protobuf:"bytes,17,opt,name=encryption_configuration,json=encryptionConfiguration,proto3" json:"encryption_configuration,omitempty"`
	// Output only. Type of the model resource.
	ModelType Model_ModelType `protobuf:"varint,7,opt,name=model_type,json=modelType,proto3,enum=google.cloud.bigquery.v2.Model_ModelType" json:"model_type,omitempty"`
	// Output only. Information for all training runs in increasing order of start_time.
	TrainingRuns []*Model_TrainingRun `protobuf:"bytes,9,rep,name=training_runs,json=trainingRuns,proto3" json:"training_runs,omitempty"`
	// Output only. Input feature columns that were used to train this model.
	FeatureColumns []*StandardSqlField `protobuf:"bytes,10,rep,name=feature_columns,json=featureColumns,proto3" json:"feature_columns,omitempty"`
	// Output only. Label columns that were used to train this model.
	// The output of the model will have a "predicted_" prefix to these columns.
	LabelColumns []*StandardSqlField `protobuf:"bytes,11,rep,name=label_columns,json=labelColumns,proto3" json:"label_columns,omitempty"`
}

func (x *Model) Reset() {
	*x = Model{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model) ProtoMessage() {}

func (x *Model) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model.ProtoReflect.Descriptor instead.
func (*Model) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0}
}

func (x *Model) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *Model) GetModelReference() *ModelReference {
	if x != nil {
		return x.ModelReference
	}
	return nil
}

func (x *Model) GetCreationTime() int64 {
	if x != nil {
		return x.CreationTime
	}
	return 0
}

func (x *Model) GetLastModifiedTime() int64 {
	if x != nil {
		return x.LastModifiedTime
	}
	return 0
}

func (x *Model) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Model) GetFriendlyName() string {
	if x != nil {
		return x.FriendlyName
	}
	return ""
}

func (x *Model) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Model) GetExpirationTime() int64 {
	if x != nil {
		return x.ExpirationTime
	}
	return 0
}

func (x *Model) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *Model) GetEncryptionConfiguration() *EncryptionConfiguration {
	if x != nil {
		return x.EncryptionConfiguration
	}
	return nil
}

func (x *Model) GetModelType() Model_ModelType {
	if x != nil {
		return x.ModelType
	}
	return Model_MODEL_TYPE_UNSPECIFIED
}

func (x *Model) GetTrainingRuns() []*Model_TrainingRun {
	if x != nil {
		return x.TrainingRuns
	}
	return nil
}

func (x *Model) GetFeatureColumns() []*StandardSqlField {
	if x != nil {
		return x.FeatureColumns
	}
	return nil
}

func (x *Model) GetLabelColumns() []*StandardSqlField {
	if x != nil {
		return x.LabelColumns
	}
	return nil
}

type GetModelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Project ID of the requested model.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. Dataset ID of the requested model.
	DatasetId string `protobuf:"bytes,2,opt,name=dataset_id,json=datasetId,proto3" json:"dataset_id,omitempty"`
	// Required. Model ID of the requested model.
	ModelId string `protobuf:"bytes,3,opt,name=model_id,json=modelId,proto3" json:"model_id,omitempty"`
}

func (x *GetModelRequest) Reset() {
	*x = GetModelRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetModelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetModelRequest) ProtoMessage() {}

func (x *GetModelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetModelRequest.ProtoReflect.Descriptor instead.
func (*GetModelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{1}
}

func (x *GetModelRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *GetModelRequest) GetDatasetId() string {
	if x != nil {
		return x.DatasetId
	}
	return ""
}

func (x *GetModelRequest) GetModelId() string {
	if x != nil {
		return x.ModelId
	}
	return ""
}

type PatchModelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Project ID of the model to patch.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. Dataset ID of the model to patch.
	DatasetId string `protobuf:"bytes,2,opt,name=dataset_id,json=datasetId,proto3" json:"dataset_id,omitempty"`
	// Required. Model ID of the model to patch.
	ModelId string `protobuf:"bytes,3,opt,name=model_id,json=modelId,proto3" json:"model_id,omitempty"`
	// Required. Patched model.
	// Follows RFC5789 patch semantics. Missing fields are not updated.
	// To clear a field, explicitly set to default value.
	Model *Model `protobuf:"bytes,4,opt,name=model,proto3" json:"model,omitempty"`
}

func (x *PatchModelRequest) Reset() {
	*x = PatchModelRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PatchModelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PatchModelRequest) ProtoMessage() {}

func (x *PatchModelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PatchModelRequest.ProtoReflect.Descriptor instead.
func (*PatchModelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{2}
}

func (x *PatchModelRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *PatchModelRequest) GetDatasetId() string {
	if x != nil {
		return x.DatasetId
	}
	return ""
}

func (x *PatchModelRequest) GetModelId() string {
	if x != nil {
		return x.ModelId
	}
	return ""
}

func (x *PatchModelRequest) GetModel() *Model {
	if x != nil {
		return x.Model
	}
	return nil
}

type DeleteModelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Project ID of the model to delete.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. Dataset ID of the model to delete.
	DatasetId string `protobuf:"bytes,2,opt,name=dataset_id,json=datasetId,proto3" json:"dataset_id,omitempty"`
	// Required. Model ID of the model to delete.
	ModelId string `protobuf:"bytes,3,opt,name=model_id,json=modelId,proto3" json:"model_id,omitempty"`
}

func (x *DeleteModelRequest) Reset() {
	*x = DeleteModelRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteModelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteModelRequest) ProtoMessage() {}

func (x *DeleteModelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteModelRequest.ProtoReflect.Descriptor instead.
func (*DeleteModelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{3}
}

func (x *DeleteModelRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *DeleteModelRequest) GetDatasetId() string {
	if x != nil {
		return x.DatasetId
	}
	return ""
}

func (x *DeleteModelRequest) GetModelId() string {
	if x != nil {
		return x.ModelId
	}
	return ""
}

type ListModelsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Project ID of the models to list.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. Dataset ID of the models to list.
	DatasetId string `protobuf:"bytes,2,opt,name=dataset_id,json=datasetId,proto3" json:"dataset_id,omitempty"`
	// The maximum number of results to return in a single response page.
	// Leverage the page tokens to iterate through the entire collection.
	MaxResults *wrapperspb.UInt32Value `protobuf:"bytes,3,opt,name=max_results,json=maxResults,proto3" json:"max_results,omitempty"`
	// Page token, returned by a previous call to request the next page of
	// results
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListModelsRequest) Reset() {
	*x = ListModelsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListModelsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListModelsRequest) ProtoMessage() {}

func (x *ListModelsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListModelsRequest.ProtoReflect.Descriptor instead.
func (*ListModelsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{4}
}

func (x *ListModelsRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *ListModelsRequest) GetDatasetId() string {
	if x != nil {
		return x.DatasetId
	}
	return ""
}

func (x *ListModelsRequest) GetMaxResults() *wrapperspb.UInt32Value {
	if x != nil {
		return x.MaxResults
	}
	return nil
}

func (x *ListModelsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

type ListModelsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Models in the requested dataset. Only the following fields are populated:
	// model_reference, model_type, creation_time, last_modified_time and
	// labels.
	Models []*Model `protobuf:"bytes,1,rep,name=models,proto3" json:"models,omitempty"`
	// A token to request the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListModelsResponse) Reset() {
	*x = ListModelsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListModelsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListModelsResponse) ProtoMessage() {}

func (x *ListModelsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListModelsResponse.ProtoReflect.Descriptor instead.
func (*ListModelsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{5}
}

func (x *ListModelsResponse) GetModels() []*Model {
	if x != nil {
		return x.Models
	}
	return nil
}

func (x *ListModelsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

type Model_SeasonalPeriod struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Model_SeasonalPeriod) Reset() {
	*x = Model_SeasonalPeriod{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_SeasonalPeriod) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_SeasonalPeriod) ProtoMessage() {}

func (x *Model_SeasonalPeriod) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_SeasonalPeriod.ProtoReflect.Descriptor instead.
func (*Model_SeasonalPeriod) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 0}
}

type Model_KmeansEnums struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Model_KmeansEnums) Reset() {
	*x = Model_KmeansEnums{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_KmeansEnums) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_KmeansEnums) ProtoMessage() {}

func (x *Model_KmeansEnums) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_KmeansEnums.ProtoReflect.Descriptor instead.
func (*Model_KmeansEnums) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 1}
}

// Evaluation metrics for regression and explicit feedback type matrix
// factorization models.
type Model_RegressionMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Mean absolute error.
	MeanAbsoluteError *wrapperspb.DoubleValue `protobuf:"bytes,1,opt,name=mean_absolute_error,json=meanAbsoluteError,proto3" json:"mean_absolute_error,omitempty"`
	// Mean squared error.
	MeanSquaredError *wrapperspb.DoubleValue `protobuf:"bytes,2,opt,name=mean_squared_error,json=meanSquaredError,proto3" json:"mean_squared_error,omitempty"`
	// Mean squared log error.
	MeanSquaredLogError *wrapperspb.DoubleValue `protobuf:"bytes,3,opt,name=mean_squared_log_error,json=meanSquaredLogError,proto3" json:"mean_squared_log_error,omitempty"`
	// Median absolute error.
	MedianAbsoluteError *wrapperspb.DoubleValue `protobuf:"bytes,4,opt,name=median_absolute_error,json=medianAbsoluteError,proto3" json:"median_absolute_error,omitempty"`
	// R^2 score.
	RSquared *wrapperspb.DoubleValue `protobuf:"bytes,5,opt,name=r_squared,json=rSquared,proto3" json:"r_squared,omitempty"`
}

func (x *Model_RegressionMetrics) Reset() {
	*x = Model_RegressionMetrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_RegressionMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_RegressionMetrics) ProtoMessage() {}

func (x *Model_RegressionMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_RegressionMetrics.ProtoReflect.Descriptor instead.
func (*Model_RegressionMetrics) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 2}
}

func (x *Model_RegressionMetrics) GetMeanAbsoluteError() *wrapperspb.DoubleValue {
	if x != nil {
		return x.MeanAbsoluteError
	}
	return nil
}

func (x *Model_RegressionMetrics) GetMeanSquaredError() *wrapperspb.DoubleValue {
	if x != nil {
		return x.MeanSquaredError
	}
	return nil
}

func (x *Model_RegressionMetrics) GetMeanSquaredLogError() *wrapperspb.DoubleValue {
	if x != nil {
		return x.MeanSquaredLogError
	}
	return nil
}

func (x *Model_RegressionMetrics) GetMedianAbsoluteError() *wrapperspb.DoubleValue {
	if x != nil {
		return x.MedianAbsoluteError
	}
	return nil
}

func (x *Model_RegressionMetrics) GetRSquared() *wrapperspb.DoubleValue {
	if x != nil {
		return x.RSquared
	}
	return nil
}

// Aggregate metrics for classification/classifier models. For multi-class
// models, the metrics are either macro-averaged or micro-averaged. When
// macro-averaged, the metrics are calculated for each label and then an
// unweighted average is taken of those values. When micro-averaged, the
// metric is calculated globally by counting the total number of correctly
// predicted rows.
type Model_AggregateClassificationMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Precision is the fraction of actual positive predictions that had
	// positive actual labels. For multiclass this is a macro-averaged
	// metric treating each class as a binary classifier.
	Precision *wrapperspb.DoubleValue `protobuf:"bytes,1,opt,name=precision,proto3" json:"precision,omitempty"`
	// Recall is the fraction of actual positive labels that were given a
	// positive prediction. For multiclass this is a macro-averaged metric.
	Recall *wrapperspb.DoubleValue `protobuf:"bytes,2,opt,name=recall,proto3" json:"recall,omitempty"`
	// Accuracy is the fraction of predictions given the correct label. For
	// multiclass this is a micro-averaged metric.
	Accuracy *wrapperspb.DoubleValue `protobuf:"bytes,3,opt,name=accuracy,proto3" json:"accuracy,omitempty"`
	// Threshold at which the metrics are computed. For binary
	// classification models this is the positive class threshold.
	// For multi-class classfication models this is the confidence
	// threshold.
	Threshold *wrapperspb.DoubleValue `protobuf:"bytes,4,opt,name=threshold,proto3" json:"threshold,omitempty"`
	// The F1 score is an average of recall and precision. For multiclass
	// this is a macro-averaged metric.
	F1Score *wrapperspb.DoubleValue `protobuf:"bytes,5,opt,name=f1_score,json=f1Score,proto3" json:"f1_score,omitempty"`
	// Logarithmic Loss. For multiclass this is a macro-averaged metric.
	LogLoss *wrapperspb.DoubleValue `protobuf:"bytes,6,opt,name=log_loss,json=logLoss,proto3" json:"log_loss,omitempty"`
	// Area Under a ROC Curve. For multiclass this is a macro-averaged
	// metric.
	RocAuc *wrapperspb.DoubleValue `protobuf:"bytes,7,opt,name=roc_auc,json=rocAuc,proto3" json:"roc_auc,omitempty"`
}

func (x *Model_AggregateClassificationMetrics) Reset() {
	*x = Model_AggregateClassificationMetrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_AggregateClassificationMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_AggregateClassificationMetrics) ProtoMessage() {}

func (x *Model_AggregateClassificationMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_AggregateClassificationMetrics.ProtoReflect.Descriptor instead.
func (*Model_AggregateClassificationMetrics) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 3}
}

func (x *Model_AggregateClassificationMetrics) GetPrecision() *wrapperspb.DoubleValue {
	if x != nil {
		return x.Precision
	}
	return nil
}

func (x *Model_AggregateClassificationMetrics) GetRecall() *wrapperspb.DoubleValue {
	if x != nil {
		return x.Recall
	}
	return nil
}

func (x *Model_AggregateClassificationMetrics) GetAccuracy() *wrapperspb.DoubleValue {
	if x != nil {
		return x.Accuracy
	}
	return nil
}

func (x *Model_AggregateClassificationMetrics) GetThreshold() *wrapperspb.DoubleValue {
	if x != nil {
		return x.Threshold
	}
	return nil
}

func (x *Model_AggregateClassificationMetrics) GetF1Score() *wrapperspb.DoubleValue {
	if x != nil {
		return x.F1Score
	}
	return nil
}

func (x *Model_AggregateClassificationMetrics) GetLogLoss() *wrapperspb.DoubleValue {
	if x != nil {
		return x.LogLoss
	}
	return nil
}

func (x *Model_AggregateClassificationMetrics) GetRocAuc() *wrapperspb.DoubleValue {
	if x != nil {
		return x.RocAuc
	}
	return nil
}

// Evaluation metrics for binary classification/classifier models.
type Model_BinaryClassificationMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Aggregate classification metrics.
	AggregateClassificationMetrics *Model_AggregateClassificationMetrics `protobuf:"bytes,1,opt,name=aggregate_classification_metrics,json=aggregateClassificationMetrics,proto3" json:"aggregate_classification_metrics,omitempty"`
	// Binary confusion matrix at multiple thresholds.
	BinaryConfusionMatrixList []*Model_BinaryClassificationMetrics_BinaryConfusionMatrix `protobuf:"bytes,2,rep,name=binary_confusion_matrix_list,json=binaryConfusionMatrixList,proto3" json:"binary_confusion_matrix_list,omitempty"`
	// Label representing the positive class.
	PositiveLabel string `protobuf:"bytes,3,opt,name=positive_label,json=positiveLabel,proto3" json:"positive_label,omitempty"`
	// Label representing the negative class.
	NegativeLabel string `protobuf:"bytes,4,opt,name=negative_label,json=negativeLabel,proto3" json:"negative_label,omitempty"`
}

func (x *Model_BinaryClassificationMetrics) Reset() {
	*x = Model_BinaryClassificationMetrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_BinaryClassificationMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_BinaryClassificationMetrics) ProtoMessage() {}

func (x *Model_BinaryClassificationMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_BinaryClassificationMetrics.ProtoReflect.Descriptor instead.
func (*Model_BinaryClassificationMetrics) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 4}
}

func (x *Model_BinaryClassificationMetrics) GetAggregateClassificationMetrics() *Model_AggregateClassificationMetrics {
	if x != nil {
		return x.AggregateClassificationMetrics
	}
	return nil
}

func (x *Model_BinaryClassificationMetrics) GetBinaryConfusionMatrixList() []*Model_BinaryClassificationMetrics_BinaryConfusionMatrix {
	if x != nil {
		return x.BinaryConfusionMatrixList
	}
	return nil
}

func (x *Model_BinaryClassificationMetrics) GetPositiveLabel() string {
	if x != nil {
		return x.PositiveLabel
	}
	return ""
}

func (x *Model_BinaryClassificationMetrics) GetNegativeLabel() string {
	if x != nil {
		return x.NegativeLabel
	}
	return ""
}

// Evaluation metrics for multi-class classification/classifier models.
type Model_MultiClassClassificationMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Aggregate classification metrics.
	AggregateClassificationMetrics *Model_AggregateClassificationMetrics `protobuf:"bytes,1,opt,name=aggregate_classification_metrics,json=aggregateClassificationMetrics,proto3" json:"aggregate_classification_metrics,omitempty"`
	// Confusion matrix at different thresholds.
	ConfusionMatrixList []*Model_MultiClassClassificationMetrics_ConfusionMatrix `protobuf:"bytes,2,rep,name=confusion_matrix_list,json=confusionMatrixList,proto3" json:"confusion_matrix_list,omitempty"`
}

func (x *Model_MultiClassClassificationMetrics) Reset() {
	*x = Model_MultiClassClassificationMetrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_MultiClassClassificationMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_MultiClassClassificationMetrics) ProtoMessage() {}

func (x *Model_MultiClassClassificationMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_MultiClassClassificationMetrics.ProtoReflect.Descriptor instead.
func (*Model_MultiClassClassificationMetrics) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 5}
}

func (x *Model_MultiClassClassificationMetrics) GetAggregateClassificationMetrics() *Model_AggregateClassificationMetrics {
	if x != nil {
		return x.AggregateClassificationMetrics
	}
	return nil
}

func (x *Model_MultiClassClassificationMetrics) GetConfusionMatrixList() []*Model_MultiClassClassificationMetrics_ConfusionMatrix {
	if x != nil {
		return x.ConfusionMatrixList
	}
	return nil
}

// Evaluation metrics for clustering models.
type Model_ClusteringMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Davies-Bouldin index.
	DaviesBouldinIndex *wrapperspb.DoubleValue `protobuf:"bytes,1,opt,name=davies_bouldin_index,json=daviesBouldinIndex,proto3" json:"davies_bouldin_index,omitempty"`
	// Mean of squared distances between each sample to its cluster centroid.
	MeanSquaredDistance *wrapperspb.DoubleValue `protobuf:"bytes,2,opt,name=mean_squared_distance,json=meanSquaredDistance,proto3" json:"mean_squared_distance,omitempty"`
	// [Beta] Information for all clusters.
	Clusters []*Model_ClusteringMetrics_Cluster `protobuf:"bytes,3,rep,name=clusters,proto3" json:"clusters,omitempty"`
}

func (x *Model_ClusteringMetrics) Reset() {
	*x = Model_ClusteringMetrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_ClusteringMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_ClusteringMetrics) ProtoMessage() {}

func (x *Model_ClusteringMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_ClusteringMetrics.ProtoReflect.Descriptor instead.
func (*Model_ClusteringMetrics) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 6}
}

func (x *Model_ClusteringMetrics) GetDaviesBouldinIndex() *wrapperspb.DoubleValue {
	if x != nil {
		return x.DaviesBouldinIndex
	}
	return nil
}

func (x *Model_ClusteringMetrics) GetMeanSquaredDistance() *wrapperspb.DoubleValue {
	if x != nil {
		return x.MeanSquaredDistance
	}
	return nil
}

func (x *Model_ClusteringMetrics) GetClusters() []*Model_ClusteringMetrics_Cluster {
	if x != nil {
		return x.Clusters
	}
	return nil
}

// Evaluation metrics used by weighted-ALS models specified by
// feedback_type=implicit.
type Model_RankingMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Calculates a precision per user for all the items by ranking them and
	// then averages all the precisions across all the users.
	MeanAveragePrecision *wrapperspb.DoubleValue `protobuf:"bytes,1,opt,name=mean_average_precision,json=meanAveragePrecision,proto3" json:"mean_average_precision,omitempty"`
	// Similar to the mean squared error computed in regression and explicit
	// recommendation models except instead of computing the rating directly,
	// the output from evaluate is computed against a preference which is 1 or 0
	// depending on if the rating exists or not.
	MeanSquaredError *wrapperspb.DoubleValue `protobuf:"bytes,2,opt,name=mean_squared_error,json=meanSquaredError,proto3" json:"mean_squared_error,omitempty"`
	// A metric to determine the goodness of a ranking calculated from the
	// predicted confidence by comparing it to an ideal rank measured by the
	// original ratings.
	NormalizedDiscountedCumulativeGain *wrapperspb.DoubleValue `protobuf:"bytes,3,opt,name=normalized_discounted_cumulative_gain,json=normalizedDiscountedCumulativeGain,proto3" json:"normalized_discounted_cumulative_gain,omitempty"`
	// Determines the goodness of a ranking by computing the percentile rank
	// from the predicted confidence and dividing it by the original rank.
	AverageRank *wrapperspb.DoubleValue `protobuf:"bytes,4,opt,name=average_rank,json=averageRank,proto3" json:"average_rank,omitempty"`
}

func (x *Model_RankingMetrics) Reset() {
	*x = Model_RankingMetrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_RankingMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_RankingMetrics) ProtoMessage() {}

func (x *Model_RankingMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_RankingMetrics.ProtoReflect.Descriptor instead.
func (*Model_RankingMetrics) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 7}
}

func (x *Model_RankingMetrics) GetMeanAveragePrecision() *wrapperspb.DoubleValue {
	if x != nil {
		return x.MeanAveragePrecision
	}
	return nil
}

func (x *Model_RankingMetrics) GetMeanSquaredError() *wrapperspb.DoubleValue {
	if x != nil {
		return x.MeanSquaredError
	}
	return nil
}

func (x *Model_RankingMetrics) GetNormalizedDiscountedCumulativeGain() *wrapperspb.DoubleValue {
	if x != nil {
		return x.NormalizedDiscountedCumulativeGain
	}
	return nil
}

func (x *Model_RankingMetrics) GetAverageRank() *wrapperspb.DoubleValue {
	if x != nil {
		return x.AverageRank
	}
	return nil
}

// Model evaluation metrics for ARIMA forecasting models.
type Model_ArimaForecastingMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Non-seasonal order.
	NonSeasonalOrder []*Model_ArimaOrder `protobuf:"bytes,1,rep,name=non_seasonal_order,json=nonSeasonalOrder,proto3" json:"non_seasonal_order,omitempty"`
	// Arima model fitting metrics.
	ArimaFittingMetrics []*Model_ArimaFittingMetrics `protobuf:"bytes,2,rep,name=arima_fitting_metrics,json=arimaFittingMetrics,proto3" json:"arima_fitting_metrics,omitempty"`
	// Seasonal periods. Repeated because multiple periods are supported for one
	// time series.
	SeasonalPeriods []Model_SeasonalPeriod_SeasonalPeriodType `protobuf:"varint,3,rep,packed,name=seasonal_periods,json=seasonalPeriods,proto3,enum=google.cloud.bigquery.v2.Model_SeasonalPeriod_SeasonalPeriodType" json:"seasonal_periods,omitempty"`
	// Whether Arima model fitted with drift or not. It is always false when d
	// is not 1.
	HasDrift []bool `protobuf:"varint,4,rep,packed,name=has_drift,json=hasDrift,proto3" json:"has_drift,omitempty"`
	// Id to differentiate different time series for the large-scale case.
	TimeSeriesId []string `protobuf:"bytes,5,rep,name=time_series_id,json=timeSeriesId,proto3" json:"time_series_id,omitempty"`
	// Repeated as there can be many metric sets (one for each model) in
	// auto-arima and the large-scale case.
	ArimaSingleModelForecastingMetrics []*Model_ArimaForecastingMetrics_ArimaSingleModelForecastingMetrics `protobuf:"bytes,6,rep,name=arima_single_model_forecasting_metrics,json=arimaSingleModelForecastingMetrics,proto3" json:"arima_single_model_forecasting_metrics,omitempty"`
}

func (x *Model_ArimaForecastingMetrics) Reset() {
	*x = Model_ArimaForecastingMetrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_ArimaForecastingMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_ArimaForecastingMetrics) ProtoMessage() {}

func (x *Model_ArimaForecastingMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_ArimaForecastingMetrics.ProtoReflect.Descriptor instead.
func (*Model_ArimaForecastingMetrics) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 8}
}

func (x *Model_ArimaForecastingMetrics) GetNonSeasonalOrder() []*Model_ArimaOrder {
	if x != nil {
		return x.NonSeasonalOrder
	}
	return nil
}

func (x *Model_ArimaForecastingMetrics) GetArimaFittingMetrics() []*Model_ArimaFittingMetrics {
	if x != nil {
		return x.ArimaFittingMetrics
	}
	return nil
}

func (x *Model_ArimaForecastingMetrics) GetSeasonalPeriods() []Model_SeasonalPeriod_SeasonalPeriodType {
	if x != nil {
		return x.SeasonalPeriods
	}
	return nil
}

func (x *Model_ArimaForecastingMetrics) GetHasDrift() []bool {
	if x != nil {
		return x.HasDrift
	}
	return nil
}

func (x *Model_ArimaForecastingMetrics) GetTimeSeriesId() []string {
	if x != nil {
		return x.TimeSeriesId
	}
	return nil
}

func (x *Model_ArimaForecastingMetrics) GetArimaSingleModelForecastingMetrics() []*Model_ArimaForecastingMetrics_ArimaSingleModelForecastingMetrics {
	if x != nil {
		return x.ArimaSingleModelForecastingMetrics
	}
	return nil
}

// Evaluation metrics of a model. These are either computed on all training
// data or just the eval data based on whether eval data was used during
// training. These are not present for imported models.
type Model_EvaluationMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Metrics:
	//	*Model_EvaluationMetrics_RegressionMetrics
	//	*Model_EvaluationMetrics_BinaryClassificationMetrics
	//	*Model_EvaluationMetrics_MultiClassClassificationMetrics
	//	*Model_EvaluationMetrics_ClusteringMetrics
	//	*Model_EvaluationMetrics_RankingMetrics
	//	*Model_EvaluationMetrics_ArimaForecastingMetrics
	Metrics isModel_EvaluationMetrics_Metrics `protobuf_oneof:"metrics"`
}

func (x *Model_EvaluationMetrics) Reset() {
	*x = Model_EvaluationMetrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_EvaluationMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_EvaluationMetrics) ProtoMessage() {}

func (x *Model_EvaluationMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_EvaluationMetrics.ProtoReflect.Descriptor instead.
func (*Model_EvaluationMetrics) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 9}
}

func (m *Model_EvaluationMetrics) GetMetrics() isModel_EvaluationMetrics_Metrics {
	if m != nil {
		return m.Metrics
	}
	return nil
}

func (x *Model_EvaluationMetrics) GetRegressionMetrics() *Model_RegressionMetrics {
	if x, ok := x.GetMetrics().(*Model_EvaluationMetrics_RegressionMetrics); ok {
		return x.RegressionMetrics
	}
	return nil
}

func (x *Model_EvaluationMetrics) GetBinaryClassificationMetrics() *Model_BinaryClassificationMetrics {
	if x, ok := x.GetMetrics().(*Model_EvaluationMetrics_BinaryClassificationMetrics); ok {
		return x.BinaryClassificationMetrics
	}
	return nil
}

func (x *Model_EvaluationMetrics) GetMultiClassClassificationMetrics() *Model_MultiClassClassificationMetrics {
	if x, ok := x.GetMetrics().(*Model_EvaluationMetrics_MultiClassClassificationMetrics); ok {
		return x.MultiClassClassificationMetrics
	}
	return nil
}

func (x *Model_EvaluationMetrics) GetClusteringMetrics() *Model_ClusteringMetrics {
	if x, ok := x.GetMetrics().(*Model_EvaluationMetrics_ClusteringMetrics); ok {
		return x.ClusteringMetrics
	}
	return nil
}

func (x *Model_EvaluationMetrics) GetRankingMetrics() *Model_RankingMetrics {
	if x, ok := x.GetMetrics().(*Model_EvaluationMetrics_RankingMetrics); ok {
		return x.RankingMetrics
	}
	return nil
}

func (x *Model_EvaluationMetrics) GetArimaForecastingMetrics() *Model_ArimaForecastingMetrics {
	if x, ok := x.GetMetrics().(*Model_EvaluationMetrics_ArimaForecastingMetrics); ok {
		return x.ArimaForecastingMetrics
	}
	return nil
}

type isModel_EvaluationMetrics_Metrics interface {
	isModel_EvaluationMetrics_Metrics()
}

type Model_EvaluationMetrics_RegressionMetrics struct {
	// Populated for regression models and explicit feedback type matrix
	// factorization models.
	RegressionMetrics *Model_RegressionMetrics `protobuf:"bytes,1,opt,name=regression_metrics,json=regressionMetrics,proto3,oneof"`
}

type Model_EvaluationMetrics_BinaryClassificationMetrics struct {
	// Populated for binary classification/classifier models.
	BinaryClassificationMetrics *Model_BinaryClassificationMetrics `protobuf:"bytes,2,opt,name=binary_classification_metrics,json=binaryClassificationMetrics,proto3,oneof"`
}

type Model_EvaluationMetrics_MultiClassClassificationMetrics struct {
	// Populated for multi-class classification/classifier models.
	MultiClassClassificationMetrics *Model_MultiClassClassificationMetrics `protobuf:"bytes,3,opt,name=multi_class_classification_metrics,json=multiClassClassificationMetrics,proto3,oneof"`
}

type Model_EvaluationMetrics_ClusteringMetrics struct {
	// Populated for clustering models.
	ClusteringMetrics *Model_ClusteringMetrics `protobuf:"bytes,4,opt,name=clustering_metrics,json=clusteringMetrics,proto3,oneof"`
}

type Model_EvaluationMetrics_RankingMetrics struct {
	// Populated for implicit feedback type matrix factorization models.
	RankingMetrics *Model_RankingMetrics `protobuf:"bytes,5,opt,name=ranking_metrics,json=rankingMetrics,proto3,oneof"`
}

type Model_EvaluationMetrics_ArimaForecastingMetrics struct {
	// Populated for ARIMA models.
	ArimaForecastingMetrics *Model_ArimaForecastingMetrics `protobuf:"bytes,6,opt,name=arima_forecasting_metrics,json=arimaForecastingMetrics,proto3,oneof"`
}

func (*Model_EvaluationMetrics_RegressionMetrics) isModel_EvaluationMetrics_Metrics() {}

func (*Model_EvaluationMetrics_BinaryClassificationMetrics) isModel_EvaluationMetrics_Metrics() {}

func (*Model_EvaluationMetrics_MultiClassClassificationMetrics) isModel_EvaluationMetrics_Metrics() {}

func (*Model_EvaluationMetrics_ClusteringMetrics) isModel_EvaluationMetrics_Metrics() {}

func (*Model_EvaluationMetrics_RankingMetrics) isModel_EvaluationMetrics_Metrics() {}

func (*Model_EvaluationMetrics_ArimaForecastingMetrics) isModel_EvaluationMetrics_Metrics() {}

// Data split result. This contains references to the training and evaluation
// data tables that were used to train the model.
type Model_DataSplitResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Table reference of the training data after split.
	TrainingTable *TableReference `protobuf:"bytes,1,opt,name=training_table,json=trainingTable,proto3" json:"training_table,omitempty"`
	// Table reference of the evaluation data after split.
	EvaluationTable *TableReference `protobuf:"bytes,2,opt,name=evaluation_table,json=evaluationTable,proto3" json:"evaluation_table,omitempty"`
}

func (x *Model_DataSplitResult) Reset() {
	*x = Model_DataSplitResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_DataSplitResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_DataSplitResult) ProtoMessage() {}

func (x *Model_DataSplitResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_DataSplitResult.ProtoReflect.Descriptor instead.
func (*Model_DataSplitResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 10}
}

func (x *Model_DataSplitResult) GetTrainingTable() *TableReference {
	if x != nil {
		return x.TrainingTable
	}
	return nil
}

func (x *Model_DataSplitResult) GetEvaluationTable() *TableReference {
	if x != nil {
		return x.EvaluationTable
	}
	return nil
}

// Arima order, can be used for both non-seasonal and seasonal parts.
type Model_ArimaOrder struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Order of the autoregressive part.
	P int64 `protobuf:"varint,1,opt,name=p,proto3" json:"p,omitempty"`
	// Order of the differencing part.
	D int64 `protobuf:"varint,2,opt,name=d,proto3" json:"d,omitempty"`
	// Order of the moving-average part.
	Q int64 `protobuf:"varint,3,opt,name=q,proto3" json:"q,omitempty"`
}

func (x *Model_ArimaOrder) Reset() {
	*x = Model_ArimaOrder{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_ArimaOrder) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_ArimaOrder) ProtoMessage() {}

func (x *Model_ArimaOrder) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_ArimaOrder.ProtoReflect.Descriptor instead.
func (*Model_ArimaOrder) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 11}
}

func (x *Model_ArimaOrder) GetP() int64 {
	if x != nil {
		return x.P
	}
	return 0
}

func (x *Model_ArimaOrder) GetD() int64 {
	if x != nil {
		return x.D
	}
	return 0
}

func (x *Model_ArimaOrder) GetQ() int64 {
	if x != nil {
		return x.Q
	}
	return 0
}

// ARIMA model fitting metrics.
type Model_ArimaFittingMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Log-likelihood.
	LogLikelihood float64 `protobuf:"fixed64,1,opt,name=log_likelihood,json=logLikelihood,proto3" json:"log_likelihood,omitempty"`
	// AIC.
	Aic float64 `protobuf:"fixed64,2,opt,name=aic,proto3" json:"aic,omitempty"`
	// Variance.
	Variance float64 `protobuf:"fixed64,3,opt,name=variance,proto3" json:"variance,omitempty"`
}

func (x *Model_ArimaFittingMetrics) Reset() {
	*x = Model_ArimaFittingMetrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_ArimaFittingMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_ArimaFittingMetrics) ProtoMessage() {}

func (x *Model_ArimaFittingMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_ArimaFittingMetrics.ProtoReflect.Descriptor instead.
func (*Model_ArimaFittingMetrics) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 12}
}

func (x *Model_ArimaFittingMetrics) GetLogLikelihood() float64 {
	if x != nil {
		return x.LogLikelihood
	}
	return 0
}

func (x *Model_ArimaFittingMetrics) GetAic() float64 {
	if x != nil {
		return x.Aic
	}
	return 0
}

func (x *Model_ArimaFittingMetrics) GetVariance() float64 {
	if x != nil {
		return x.Variance
	}
	return 0
}

// Global explanations containing the top most important features
// after training.
type Model_GlobalExplanation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of the top global explanations. Sorted by absolute value of
	// attribution in descending order.
	Explanations []*Model_GlobalExplanation_Explanation `protobuf:"bytes,1,rep,name=explanations,proto3" json:"explanations,omitempty"`
	// Class label for this set of global explanations. Will be empty/null for
	// binary logistic and linear regression models. Sorted alphabetically in
	// descending order.
	ClassLabel string `protobuf:"bytes,2,opt,name=class_label,json=classLabel,proto3" json:"class_label,omitempty"`
}

func (x *Model_GlobalExplanation) Reset() {
	*x = Model_GlobalExplanation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_GlobalExplanation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_GlobalExplanation) ProtoMessage() {}

func (x *Model_GlobalExplanation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_GlobalExplanation.ProtoReflect.Descriptor instead.
func (*Model_GlobalExplanation) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 13}
}

func (x *Model_GlobalExplanation) GetExplanations() []*Model_GlobalExplanation_Explanation {
	if x != nil {
		return x.Explanations
	}
	return nil
}

func (x *Model_GlobalExplanation) GetClassLabel() string {
	if x != nil {
		return x.ClassLabel
	}
	return ""
}

// Information about a single training query run for the model.
type Model_TrainingRun struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Options that were used for this training run, includes
	// user specified and default options that were used.
	TrainingOptions *Model_TrainingRun_TrainingOptions `protobuf:"bytes,1,opt,name=training_options,json=trainingOptions,proto3" json:"training_options,omitempty"`
	// The start time of this training run.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output of each iteration run, results.size() <= max_iterations.
	Results []*Model_TrainingRun_IterationResult `protobuf:"bytes,6,rep,name=results,proto3" json:"results,omitempty"`
	// The evaluation metrics over training/eval data that were computed at the
	// end of training.
	EvaluationMetrics *Model_EvaluationMetrics `protobuf:"bytes,7,opt,name=evaluation_metrics,json=evaluationMetrics,proto3" json:"evaluation_metrics,omitempty"`
	// Data split result of the training run. Only set when the input data is
	// actually split.
	DataSplitResult *Model_DataSplitResult `protobuf:"bytes,9,opt,name=data_split_result,json=dataSplitResult,proto3" json:"data_split_result,omitempty"`
	// Global explanations for important features of the model. For multi-class
	// models, there is one entry for each label class. For other models, there
	// is only one entry in the list.
	GlobalExplanations []*Model_GlobalExplanation `protobuf:"bytes,10,rep,name=global_explanations,json=globalExplanations,proto3" json:"global_explanations,omitempty"`
}

func (x *Model_TrainingRun) Reset() {
	*x = Model_TrainingRun{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_TrainingRun) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_TrainingRun) ProtoMessage() {}

func (x *Model_TrainingRun) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_TrainingRun.ProtoReflect.Descriptor instead.
func (*Model_TrainingRun) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 14}
}

func (x *Model_TrainingRun) GetTrainingOptions() *Model_TrainingRun_TrainingOptions {
	if x != nil {
		return x.TrainingOptions
	}
	return nil
}

func (x *Model_TrainingRun) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Model_TrainingRun) GetResults() []*Model_TrainingRun_IterationResult {
	if x != nil {
		return x.Results
	}
	return nil
}

func (x *Model_TrainingRun) GetEvaluationMetrics() *Model_EvaluationMetrics {
	if x != nil {
		return x.EvaluationMetrics
	}
	return nil
}

func (x *Model_TrainingRun) GetDataSplitResult() *Model_DataSplitResult {
	if x != nil {
		return x.DataSplitResult
	}
	return nil
}

func (x *Model_TrainingRun) GetGlobalExplanations() []*Model_GlobalExplanation {
	if x != nil {
		return x.GlobalExplanations
	}
	return nil
}

// Confusion matrix for binary classification models.
type Model_BinaryClassificationMetrics_BinaryConfusionMatrix struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Threshold value used when computing each of the following metric.
	PositiveClassThreshold *wrapperspb.DoubleValue `protobuf:"bytes,1,opt,name=positive_class_threshold,json=positiveClassThreshold,proto3" json:"positive_class_threshold,omitempty"`
	// Number of true samples predicted as true.
	TruePositives *wrapperspb.Int64Value `protobuf:"bytes,2,opt,name=true_positives,json=truePositives,proto3" json:"true_positives,omitempty"`
	// Number of false samples predicted as true.
	FalsePositives *wrapperspb.Int64Value `protobuf:"bytes,3,opt,name=false_positives,json=falsePositives,proto3" json:"false_positives,omitempty"`
	// Number of true samples predicted as false.
	TrueNegatives *wrapperspb.Int64Value `protobuf:"bytes,4,opt,name=true_negatives,json=trueNegatives,proto3" json:"true_negatives,omitempty"`
	// Number of false samples predicted as false.
	FalseNegatives *wrapperspb.Int64Value `protobuf:"bytes,5,opt,name=false_negatives,json=falseNegatives,proto3" json:"false_negatives,omitempty"`
	// The fraction of actual positive predictions that had positive actual
	// labels.
	Precision *wrapperspb.DoubleValue `protobuf:"bytes,6,opt,name=precision,proto3" json:"precision,omitempty"`
	// The fraction of actual positive labels that were given a positive
	// prediction.
	Recall *wrapperspb.DoubleValue `protobuf:"bytes,7,opt,name=recall,proto3" json:"recall,omitempty"`
	// The equally weighted average of recall and precision.
	F1Score *wrapperspb.DoubleValue `protobuf:"bytes,8,opt,name=f1_score,json=f1Score,proto3" json:"f1_score,omitempty"`
	// The fraction of predictions given the correct label.
	Accuracy *wrapperspb.DoubleValue `protobuf:"bytes,9,opt,name=accuracy,proto3" json:"accuracy,omitempty"`
}

func (x *Model_BinaryClassificationMetrics_BinaryConfusionMatrix) Reset() {
	*x = Model_BinaryClassificationMetrics_BinaryConfusionMatrix{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_BinaryClassificationMetrics_BinaryConfusionMatrix) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_BinaryClassificationMetrics_BinaryConfusionMatrix) ProtoMessage() {}

func (x *Model_BinaryClassificationMetrics_BinaryConfusionMatrix) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_BinaryClassificationMetrics_BinaryConfusionMatrix.ProtoReflect.Descriptor instead.
func (*Model_BinaryClassificationMetrics_BinaryConfusionMatrix) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 4, 0}
}

func (x *Model_BinaryClassificationMetrics_BinaryConfusionMatrix) GetPositiveClassThreshold() *wrapperspb.DoubleValue {
	if x != nil {
		return x.PositiveClassThreshold
	}
	return nil
}

func (x *Model_BinaryClassificationMetrics_BinaryConfusionMatrix) GetTruePositives() *wrapperspb.Int64Value {
	if x != nil {
		return x.TruePositives
	}
	return nil
}

func (x *Model_BinaryClassificationMetrics_BinaryConfusionMatrix) GetFalsePositives() *wrapperspb.Int64Value {
	if x != nil {
		return x.FalsePositives
	}
	return nil
}

func (x *Model_BinaryClassificationMetrics_BinaryConfusionMatrix) GetTrueNegatives() *wrapperspb.Int64Value {
	if x != nil {
		return x.TrueNegatives
	}
	return nil
}

func (x *Model_BinaryClassificationMetrics_BinaryConfusionMatrix) GetFalseNegatives() *wrapperspb.Int64Value {
	if x != nil {
		return x.FalseNegatives
	}
	return nil
}

func (x *Model_BinaryClassificationMetrics_BinaryConfusionMatrix) GetPrecision() *wrapperspb.DoubleValue {
	if x != nil {
		return x.Precision
	}
	return nil
}

func (x *Model_BinaryClassificationMetrics_BinaryConfusionMatrix) GetRecall() *wrapperspb.DoubleValue {
	if x != nil {
		return x.Recall
	}
	return nil
}

func (x *Model_BinaryClassificationMetrics_BinaryConfusionMatrix) GetF1Score() *wrapperspb.DoubleValue {
	if x != nil {
		return x.F1Score
	}
	return nil
}

func (x *Model_BinaryClassificationMetrics_BinaryConfusionMatrix) GetAccuracy() *wrapperspb.DoubleValue {
	if x != nil {
		return x.Accuracy
	}
	return nil
}

// Confusion matrix for multi-class classification models.
type Model_MultiClassClassificationMetrics_ConfusionMatrix struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Confidence threshold used when computing the entries of the
	// confusion matrix.
	ConfidenceThreshold *wrapperspb.DoubleValue `protobuf:"bytes,1,opt,name=confidence_threshold,json=confidenceThreshold,proto3" json:"confidence_threshold,omitempty"`
	// One row per actual label.
	Rows []*Model_MultiClassClassificationMetrics_ConfusionMatrix_Row `protobuf:"bytes,2,rep,name=rows,proto3" json:"rows,omitempty"`
}

func (x *Model_MultiClassClassificationMetrics_ConfusionMatrix) Reset() {
	*x = Model_MultiClassClassificationMetrics_ConfusionMatrix{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_MultiClassClassificationMetrics_ConfusionMatrix) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_MultiClassClassificationMetrics_ConfusionMatrix) ProtoMessage() {}

func (x *Model_MultiClassClassificationMetrics_ConfusionMatrix) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_MultiClassClassificationMetrics_ConfusionMatrix.ProtoReflect.Descriptor instead.
func (*Model_MultiClassClassificationMetrics_ConfusionMatrix) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 5, 0}
}

func (x *Model_MultiClassClassificationMetrics_ConfusionMatrix) GetConfidenceThreshold() *wrapperspb.DoubleValue {
	if x != nil {
		return x.ConfidenceThreshold
	}
	return nil
}

func (x *Model_MultiClassClassificationMetrics_ConfusionMatrix) GetRows() []*Model_MultiClassClassificationMetrics_ConfusionMatrix_Row {
	if x != nil {
		return x.Rows
	}
	return nil
}

// A single entry in the confusion matrix.
type Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The predicted label. For confidence_threshold > 0, we will
	// also add an entry indicating the number of items under the
	// confidence threshold.
	PredictedLabel string `protobuf:"bytes,1,opt,name=predicted_label,json=predictedLabel,proto3" json:"predicted_label,omitempty"`
	// Number of items being predicted as this label.
	ItemCount *wrapperspb.Int64Value `protobuf:"bytes,2,opt,name=item_count,json=itemCount,proto3" json:"item_count,omitempty"`
}

func (x *Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry) Reset() {
	*x = Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry) ProtoMessage() {}

func (x *Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry.ProtoReflect.Descriptor instead.
func (*Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 5, 0, 0}
}

func (x *Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry) GetPredictedLabel() string {
	if x != nil {
		return x.PredictedLabel
	}
	return ""
}

func (x *Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry) GetItemCount() *wrapperspb.Int64Value {
	if x != nil {
		return x.ItemCount
	}
	return nil
}

// A single row in the confusion matrix.
type Model_MultiClassClassificationMetrics_ConfusionMatrix_Row struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The original label of this row.
	ActualLabel string `protobuf:"bytes,1,opt,name=actual_label,json=actualLabel,proto3" json:"actual_label,omitempty"`
	// Info describing predicted label distribution.
	Entries []*Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry `protobuf:"bytes,2,rep,name=entries,proto3" json:"entries,omitempty"`
}

func (x *Model_MultiClassClassificationMetrics_ConfusionMatrix_Row) Reset() {
	*x = Model_MultiClassClassificationMetrics_ConfusionMatrix_Row{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_MultiClassClassificationMetrics_ConfusionMatrix_Row) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_MultiClassClassificationMetrics_ConfusionMatrix_Row) ProtoMessage() {}

func (x *Model_MultiClassClassificationMetrics_ConfusionMatrix_Row) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_MultiClassClassificationMetrics_ConfusionMatrix_Row.ProtoReflect.Descriptor instead.
func (*Model_MultiClassClassificationMetrics_ConfusionMatrix_Row) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 5, 0, 1}
}

func (x *Model_MultiClassClassificationMetrics_ConfusionMatrix_Row) GetActualLabel() string {
	if x != nil {
		return x.ActualLabel
	}
	return ""
}

func (x *Model_MultiClassClassificationMetrics_ConfusionMatrix_Row) GetEntries() []*Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry {
	if x != nil {
		return x.Entries
	}
	return nil
}

// Message containing the information about one cluster.
type Model_ClusteringMetrics_Cluster struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Centroid id.
	CentroidId int64 `protobuf:"varint,1,opt,name=centroid_id,json=centroidId,proto3" json:"centroid_id,omitempty"`
	// Values of highly variant features for this cluster.
	FeatureValues []*Model_ClusteringMetrics_Cluster_FeatureValue `protobuf:"bytes,2,rep,name=feature_values,json=featureValues,proto3" json:"feature_values,omitempty"`
	// Count of training data rows that were assigned to this cluster.
	Count *wrapperspb.Int64Value `protobuf:"bytes,3,opt,name=count,proto3" json:"count,omitempty"`
}

func (x *Model_ClusteringMetrics_Cluster) Reset() {
	*x = Model_ClusteringMetrics_Cluster{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_ClusteringMetrics_Cluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_ClusteringMetrics_Cluster) ProtoMessage() {}

func (x *Model_ClusteringMetrics_Cluster) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_ClusteringMetrics_Cluster.ProtoReflect.Descriptor instead.
func (*Model_ClusteringMetrics_Cluster) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 6, 0}
}

func (x *Model_ClusteringMetrics_Cluster) GetCentroidId() int64 {
	if x != nil {
		return x.CentroidId
	}
	return 0
}

func (x *Model_ClusteringMetrics_Cluster) GetFeatureValues() []*Model_ClusteringMetrics_Cluster_FeatureValue {
	if x != nil {
		return x.FeatureValues
	}
	return nil
}

func (x *Model_ClusteringMetrics_Cluster) GetCount() *wrapperspb.Int64Value {
	if x != nil {
		return x.Count
	}
	return nil
}

// Representative value of a single feature within the cluster.
type Model_ClusteringMetrics_Cluster_FeatureValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The feature column name.
	FeatureColumn string `protobuf:"bytes,1,opt,name=feature_column,json=featureColumn,proto3" json:"feature_column,omitempty"`
	// Types that are assignable to Value:
	//	*Model_ClusteringMetrics_Cluster_FeatureValue_NumericalValue
	//	*Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue_
	Value isModel_ClusteringMetrics_Cluster_FeatureValue_Value `protobuf_oneof:"value"`
}

func (x *Model_ClusteringMetrics_Cluster_FeatureValue) Reset() {
	*x = Model_ClusteringMetrics_Cluster_FeatureValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_ClusteringMetrics_Cluster_FeatureValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_ClusteringMetrics_Cluster_FeatureValue) ProtoMessage() {}

func (x *Model_ClusteringMetrics_Cluster_FeatureValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_ClusteringMetrics_Cluster_FeatureValue.ProtoReflect.Descriptor instead.
func (*Model_ClusteringMetrics_Cluster_FeatureValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 6, 0, 0}
}

func (x *Model_ClusteringMetrics_Cluster_FeatureValue) GetFeatureColumn() string {
	if x != nil {
		return x.FeatureColumn
	}
	return ""
}

func (m *Model_ClusteringMetrics_Cluster_FeatureValue) GetValue() isModel_ClusteringMetrics_Cluster_FeatureValue_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *Model_ClusteringMetrics_Cluster_FeatureValue) GetNumericalValue() *wrapperspb.DoubleValue {
	if x, ok := x.GetValue().(*Model_ClusteringMetrics_Cluster_FeatureValue_NumericalValue); ok {
		return x.NumericalValue
	}
	return nil
}

func (x *Model_ClusteringMetrics_Cluster_FeatureValue) GetCategoricalValue() *Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue {
	if x, ok := x.GetValue().(*Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue_); ok {
		return x.CategoricalValue
	}
	return nil
}

type isModel_ClusteringMetrics_Cluster_FeatureValue_Value interface {
	isModel_ClusteringMetrics_Cluster_FeatureValue_Value()
}

type Model_ClusteringMetrics_Cluster_FeatureValue_NumericalValue struct {
	// The numerical feature value. This is the centroid value for this
	// feature.
	NumericalValue *wrapperspb.DoubleValue `protobuf:"bytes,2,opt,name=numerical_value,json=numericalValue,proto3,oneof"`
}

type Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue_ struct {
	// The categorical feature value.
	CategoricalValue *Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue `protobuf:"bytes,3,opt,name=categorical_value,json=categoricalValue,proto3,oneof"`
}

func (*Model_ClusteringMetrics_Cluster_FeatureValue_NumericalValue) isModel_ClusteringMetrics_Cluster_FeatureValue_Value() {
}

func (*Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue_) isModel_ClusteringMetrics_Cluster_FeatureValue_Value() {
}

// Representative value of a categorical feature.
type Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Counts of all categories for the categorical feature. If there are
	// more than ten categories, we return top ten (by count) and return
	// one more CategoryCount with category "_OTHER_" and count as
	// aggregate counts of remaining categories.
	CategoryCounts []*Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue_CategoryCount `protobuf:"bytes,1,rep,name=category_counts,json=categoryCounts,proto3" json:"category_counts,omitempty"`
}

func (x *Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue) Reset() {
	*x = Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue) ProtoMessage() {}

func (x *Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue.ProtoReflect.Descriptor instead.
func (*Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 6, 0, 0, 0}
}

func (x *Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue) GetCategoryCounts() []*Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue_CategoryCount {
	if x != nil {
		return x.CategoryCounts
	}
	return nil
}

// Represents the count of a single category within the cluster.
type Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue_CategoryCount struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of category.
	Category string `protobuf:"bytes,1,opt,name=category,proto3" json:"category,omitempty"`
	// The count of training samples matching the category within the
	// cluster.
	Count *wrapperspb.Int64Value `protobuf:"bytes,2,opt,name=count,proto3" json:"count,omitempty"`
}

func (x *Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue_CategoryCount) Reset() {
	*x = Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue_CategoryCount{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue_CategoryCount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue_CategoryCount) ProtoMessage() {}

func (x *Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue_CategoryCount) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue_CategoryCount.ProtoReflect.Descriptor instead.
func (*Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue_CategoryCount) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 6, 0, 0, 0, 0}
}

func (x *Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue_CategoryCount) GetCategory() string {
	if x != nil {
		return x.Category
	}
	return ""
}

func (x *Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue_CategoryCount) GetCount() *wrapperspb.Int64Value {
	if x != nil {
		return x.Count
	}
	return nil
}

// Model evaluation metrics for a single ARIMA forecasting model.
type Model_ArimaForecastingMetrics_ArimaSingleModelForecastingMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Non-seasonal order.
	NonSeasonalOrder *Model_ArimaOrder `protobuf:"bytes,1,opt,name=non_seasonal_order,json=nonSeasonalOrder,proto3" json:"non_seasonal_order,omitempty"`
	// Arima fitting metrics.
	ArimaFittingMetrics *Model_ArimaFittingMetrics `protobuf:"bytes,2,opt,name=arima_fitting_metrics,json=arimaFittingMetrics,proto3" json:"arima_fitting_metrics,omitempty"`
	// Is arima model fitted with drift or not. It is always false when d
	// is not 1.
	HasDrift bool `protobuf:"varint,3,opt,name=has_drift,json=hasDrift,proto3" json:"has_drift,omitempty"`
	// The id to indicate different time series.
	TimeSeriesId string `protobuf:"bytes,4,opt,name=time_series_id,json=timeSeriesId,proto3" json:"time_series_id,omitempty"`
	// Seasonal periods. Repeated because multiple periods are supported
	// for one time series.
	SeasonalPeriods []Model_SeasonalPeriod_SeasonalPeriodType `protobuf:"varint,5,rep,packed,name=seasonal_periods,json=seasonalPeriods,proto3,enum=google.cloud.bigquery.v2.Model_SeasonalPeriod_SeasonalPeriodType" json:"seasonal_periods,omitempty"`
}

func (x *Model_ArimaForecastingMetrics_ArimaSingleModelForecastingMetrics) Reset() {
	*x = Model_ArimaForecastingMetrics_ArimaSingleModelForecastingMetrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_ArimaForecastingMetrics_ArimaSingleModelForecastingMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_ArimaForecastingMetrics_ArimaSingleModelForecastingMetrics) ProtoMessage() {}

func (x *Model_ArimaForecastingMetrics_ArimaSingleModelForecastingMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_ArimaForecastingMetrics_ArimaSingleModelForecastingMetrics.ProtoReflect.Descriptor instead.
func (*Model_ArimaForecastingMetrics_ArimaSingleModelForecastingMetrics) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 8, 0}
}

func (x *Model_ArimaForecastingMetrics_ArimaSingleModelForecastingMetrics) GetNonSeasonalOrder() *Model_ArimaOrder {
	if x != nil {
		return x.NonSeasonalOrder
	}
	return nil
}

func (x *Model_ArimaForecastingMetrics_ArimaSingleModelForecastingMetrics) GetArimaFittingMetrics() *Model_ArimaFittingMetrics {
	if x != nil {
		return x.ArimaFittingMetrics
	}
	return nil
}

func (x *Model_ArimaForecastingMetrics_ArimaSingleModelForecastingMetrics) GetHasDrift() bool {
	if x != nil {
		return x.HasDrift
	}
	return false
}

func (x *Model_ArimaForecastingMetrics_ArimaSingleModelForecastingMetrics) GetTimeSeriesId() string {
	if x != nil {
		return x.TimeSeriesId
	}
	return ""
}

func (x *Model_ArimaForecastingMetrics_ArimaSingleModelForecastingMetrics) GetSeasonalPeriods() []Model_SeasonalPeriod_SeasonalPeriodType {
	if x != nil {
		return x.SeasonalPeriods
	}
	return nil
}

// Explanation for a single feature.
type Model_GlobalExplanation_Explanation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Full name of the feature. For non-numerical features, will be
	// formatted like <column_name>.<encoded_feature_name>. Overall size of
	// feature name will always be truncated to first 120 characters.
	FeatureName string `protobuf:"bytes,1,opt,name=feature_name,json=featureName,proto3" json:"feature_name,omitempty"`
	// Attribution of feature.
	Attribution *wrapperspb.DoubleValue `protobuf:"bytes,2,opt,name=attribution,proto3" json:"attribution,omitempty"`
}

func (x *Model_GlobalExplanation_Explanation) Reset() {
	*x = Model_GlobalExplanation_Explanation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_GlobalExplanation_Explanation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_GlobalExplanation_Explanation) ProtoMessage() {}

func (x *Model_GlobalExplanation_Explanation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_GlobalExplanation_Explanation.ProtoReflect.Descriptor instead.
func (*Model_GlobalExplanation_Explanation) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 13, 0}
}

func (x *Model_GlobalExplanation_Explanation) GetFeatureName() string {
	if x != nil {
		return x.FeatureName
	}
	return ""
}

func (x *Model_GlobalExplanation_Explanation) GetAttribution() *wrapperspb.DoubleValue {
	if x != nil {
		return x.Attribution
	}
	return nil
}

type Model_TrainingRun_TrainingOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The maximum number of iterations in training. Used only for iterative
	// training algorithms.
	MaxIterations int64 `protobuf:"varint,1,opt,name=max_iterations,json=maxIterations,proto3" json:"max_iterations,omitempty"`
	// Type of loss function used during training run.
	LossType Model_LossType `protobuf:"varint,2,opt,name=loss_type,json=lossType,proto3,enum=google.cloud.bigquery.v2.Model_LossType" json:"loss_type,omitempty"`
	// Learning rate in training. Used only for iterative training algorithms.
	LearnRate float64 `protobuf:"fixed64,3,opt,name=learn_rate,json=learnRate,proto3" json:"learn_rate,omitempty"`
	// L1 regularization coefficient.
	L1Regularization *wrapperspb.DoubleValue `protobuf:"bytes,4,opt,name=l1_regularization,json=l1Regularization,proto3" json:"l1_regularization,omitempty"`
	// L2 regularization coefficient.
	L2Regularization *wrapperspb.DoubleValue `protobuf:"bytes,5,opt,name=l2_regularization,json=l2Regularization,proto3" json:"l2_regularization,omitempty"`
	// When early_stop is true, stops training when accuracy improvement is
	// less than 'min_relative_progress'. Used only for iterative training
	// algorithms.
	MinRelativeProgress *wrapperspb.DoubleValue `protobuf:"bytes,6,opt,name=min_relative_progress,json=minRelativeProgress,proto3" json:"min_relative_progress,omitempty"`
	// Whether to train a model from the last checkpoint.
	WarmStart *wrapperspb.BoolValue `protobuf:"bytes,7,opt,name=warm_start,json=warmStart,proto3" json:"warm_start,omitempty"`
	// Whether to stop early when the loss doesn't improve significantly
	// any more (compared to min_relative_progress). Used only for iterative
	// training algorithms.
	EarlyStop *wrapperspb.BoolValue `protobuf:"bytes,8,opt,name=early_stop,json=earlyStop,proto3" json:"early_stop,omitempty"`
	// Name of input label columns in training data.
	InputLabelColumns []string `protobuf:"bytes,9,rep,name=input_label_columns,json=inputLabelColumns,proto3" json:"input_label_columns,omitempty"`
	// The data split type for training and evaluation, e.g. RANDOM.
	DataSplitMethod Model_DataSplitMethod `protobuf:"varint,10,opt,name=data_split_method,json=dataSplitMethod,proto3,enum=google.cloud.bigquery.v2.Model_DataSplitMethod" json:"data_split_method,omitempty"`
	// The fraction of evaluation data over the whole input data. The rest
	// of data will be used as training data. The format should be double.
	// Accurate to two decimal places.
	// Default value is 0.2.
	DataSplitEvalFraction float64 `protobuf:"fixed64,11,opt,name=data_split_eval_fraction,json=dataSplitEvalFraction,proto3" json:"data_split_eval_fraction,omitempty"`
	// The column to split data with. This column won't be used as a
	// feature.
	// 1. When data_split_method is CUSTOM, the corresponding column should
	// be boolean. The rows with true value tag are eval data, and the false
	// are training data.
	// 2. When data_split_method is SEQ, the first DATA_SPLIT_EVAL_FRACTION
	// rows (from smallest to largest) in the corresponding column are used
	// as training data, and the rest are eval data. It respects the order
	// in Orderable data types:
	// https://cloud.google.com/bigquery/docs/reference/standard-sql/data-types#data-type-properties
	DataSplitColumn string `protobuf:"bytes,12,opt,name=data_split_column,json=dataSplitColumn,proto3" json:"data_split_column,omitempty"`
	// The strategy to determine learn rate for the current iteration.
	LearnRateStrategy Model_LearnRateStrategy `protobuf:"varint,13,opt,name=learn_rate_strategy,json=learnRateStrategy,proto3,enum=google.cloud.bigquery.v2.Model_LearnRateStrategy" json:"learn_rate_strategy,omitempty"`
	// Specifies the initial learning rate for the line search learn rate
	// strategy.
	InitialLearnRate float64 `protobuf:"fixed64,16,opt,name=initial_learn_rate,json=initialLearnRate,proto3" json:"initial_learn_rate,omitempty"`
	// Weights associated with each label class, for rebalancing the
	// training data. Only applicable for classification models.
	LabelClassWeights map[string]float64 `protobuf:"bytes,17,rep,name=label_class_weights,json=labelClassWeights,proto3" json:"label_class_weights,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"fixed64,2,opt,name=value,proto3"`
	// User column specified for matrix factorization models.
	UserColumn string `protobuf:"bytes,18,opt,name=user_column,json=userColumn,proto3" json:"user_column,omitempty"`
	// Item column specified for matrix factorization models.
	ItemColumn string `protobuf:"bytes,19,opt,name=item_column,json=itemColumn,proto3" json:"item_column,omitempty"`
	// Distance type for clustering models.
	DistanceType Model_DistanceType `protobuf:"varint,20,opt,name=distance_type,json=distanceType,proto3,enum=google.cloud.bigquery.v2.Model_DistanceType" json:"distance_type,omitempty"`
	// Number of clusters for clustering models.
	NumClusters int64 `protobuf:"varint,21,opt,name=num_clusters,json=numClusters,proto3" json:"num_clusters,omitempty"`
	// [Beta] Google Cloud Storage URI from which the model was imported. Only
	// applicable for imported models.
	ModelUri string `protobuf:"bytes,22,opt,name=model_uri,json=modelUri,proto3" json:"model_uri,omitempty"`
	// Optimization strategy for training linear regression models.
	OptimizationStrategy Model_OptimizationStrategy `protobuf:"varint,23,opt,name=optimization_strategy,json=optimizationStrategy,proto3,enum=google.cloud.bigquery.v2.Model_OptimizationStrategy" json:"optimization_strategy,omitempty"`
	// Hidden units for dnn models.
	HiddenUnits []int64 `protobuf:"varint,24,rep,packed,name=hidden_units,json=hiddenUnits,proto3" json:"hidden_units,omitempty"`
	// Batch size for dnn models.
	BatchSize int64 `protobuf:"varint,25,opt,name=batch_size,json=batchSize,proto3" json:"batch_size,omitempty"`
	// Dropout probability for dnn models.
	Dropout *wrapperspb.DoubleValue `protobuf:"bytes,26,opt,name=dropout,proto3" json:"dropout,omitempty"`
	// Maximum depth of a tree for boosted tree models.
	MaxTreeDepth int64 `protobuf:"varint,27,opt,name=max_tree_depth,json=maxTreeDepth,proto3" json:"max_tree_depth,omitempty"`
	// Subsample fraction of the training data to grow tree to prevent
	// overfitting for boosted tree models.
	Subsample float64 `protobuf:"fixed64,28,opt,name=subsample,proto3" json:"subsample,omitempty"`
	// Minimum split loss for boosted tree models.
	MinSplitLoss *wrapperspb.DoubleValue `protobuf:"bytes,29,opt,name=min_split_loss,json=minSplitLoss,proto3" json:"min_split_loss,omitempty"`
	// Num factors specified for matrix factorization models.
	NumFactors int64 `protobuf:"varint,30,opt,name=num_factors,json=numFactors,proto3" json:"num_factors,omitempty"`
	// Feedback type that specifies which algorithm to run for matrix
	// factorization.
	FeedbackType Model_FeedbackType `protobuf:"varint,31,opt,name=feedback_type,json=feedbackType,proto3,enum=google.cloud.bigquery.v2.Model_FeedbackType" json:"feedback_type,omitempty"`
	// Hyperparameter for matrix factoration when implicit feedback type is
	// specified.
	WalsAlpha *wrapperspb.DoubleValue `protobuf:"bytes,32,opt,name=wals_alpha,json=walsAlpha,proto3" json:"wals_alpha,omitempty"`
	// The method used to initialize the centroids for kmeans algorithm.
	KmeansInitializationMethod Model_KmeansEnums_KmeansInitializationMethod `protobuf:"varint,33,opt,name=kmeans_initialization_method,json=kmeansInitializationMethod,proto3,enum=google.cloud.bigquery.v2.Model_KmeansEnums_KmeansInitializationMethod" json:"kmeans_initialization_method,omitempty"`
	// The column used to provide the initial centroids for kmeans algorithm
	// when kmeans_initialization_method is CUSTOM.
	KmeansInitializationColumn string `protobuf:"bytes,34,opt,name=kmeans_initialization_column,json=kmeansInitializationColumn,proto3" json:"kmeans_initialization_column,omitempty"`
	// Column to be designated as time series timestamp for ARIMA model.
	TimeSeriesTimestampColumn string `protobuf:"bytes,35,opt,name=time_series_timestamp_column,json=timeSeriesTimestampColumn,proto3" json:"time_series_timestamp_column,omitempty"`
	// Column to be designated as time series data for ARIMA model.
	TimeSeriesDataColumn string `protobuf:"bytes,36,opt,name=time_series_data_column,json=timeSeriesDataColumn,proto3" json:"time_series_data_column,omitempty"`
	// Whether to enable auto ARIMA or not.
	AutoArima bool `protobuf:"varint,37,opt,name=auto_arima,json=autoArima,proto3" json:"auto_arima,omitempty"`
	// A specification of the non-seasonal part of the ARIMA model: the three
	// components (p, d, q) are the AR order, the degree of differencing, and
	// the MA order.
	NonSeasonalOrder *Model_ArimaOrder `protobuf:"bytes,38,opt,name=non_seasonal_order,json=nonSeasonalOrder,proto3" json:"non_seasonal_order,omitempty"`
	// The data frequency of a time series.
	DataFrequency Model_DataFrequency `protobuf:"varint,39,opt,name=data_frequency,json=dataFrequency,proto3,enum=google.cloud.bigquery.v2.Model_DataFrequency" json:"data_frequency,omitempty"`
	// Include drift when fitting an ARIMA model.
	IncludeDrift bool `protobuf:"varint,41,opt,name=include_drift,json=includeDrift,proto3" json:"include_drift,omitempty"`
	// The geographical region based on which the holidays are considered in
	// time series modeling. If a valid value is specified, then holiday
	// effects modeling is enabled.
	HolidayRegion Model_HolidayRegion `protobuf:"varint,42,opt,name=holiday_region,json=holidayRegion,proto3,enum=google.cloud.bigquery.v2.Model_HolidayRegion" json:"holiday_region,omitempty"`
	// The id column that will be used to indicate different time series to
	// forecast in parallel.
	TimeSeriesIdColumn string `protobuf:"bytes,43,opt,name=time_series_id_column,json=timeSeriesIdColumn,proto3" json:"time_series_id_column,omitempty"`
	// The number of periods ahead that need to be forecasted.
	Horizon int64 `protobuf:"varint,44,opt,name=horizon,proto3" json:"horizon,omitempty"`
	// Whether to preserve the input structs in output feature names.
	// Suppose there is a struct A with field b.
	// When false (default), the output feature name is A_b.
	// When true, the output feature name is A.b.
	PreserveInputStructs bool `protobuf:"varint,45,opt,name=preserve_input_structs,json=preserveInputStructs,proto3" json:"preserve_input_structs,omitempty"`
	// The max value of non-seasonal p and q.
	AutoArimaMaxOrder int64 `protobuf:"varint,46,opt,name=auto_arima_max_order,json=autoArimaMaxOrder,proto3" json:"auto_arima_max_order,omitempty"`
}

func (x *Model_TrainingRun_TrainingOptions) Reset() {
	*x = Model_TrainingRun_TrainingOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_TrainingRun_TrainingOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_TrainingRun_TrainingOptions) ProtoMessage() {}

func (x *Model_TrainingRun_TrainingOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_TrainingRun_TrainingOptions.ProtoReflect.Descriptor instead.
func (*Model_TrainingRun_TrainingOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 14, 0}
}

func (x *Model_TrainingRun_TrainingOptions) GetMaxIterations() int64 {
	if x != nil {
		return x.MaxIterations
	}
	return 0
}

func (x *Model_TrainingRun_TrainingOptions) GetLossType() Model_LossType {
	if x != nil {
		return x.LossType
	}
	return Model_LOSS_TYPE_UNSPECIFIED
}

func (x *Model_TrainingRun_TrainingOptions) GetLearnRate() float64 {
	if x != nil {
		return x.LearnRate
	}
	return 0
}

func (x *Model_TrainingRun_TrainingOptions) GetL1Regularization() *wrapperspb.DoubleValue {
	if x != nil {
		return x.L1Regularization
	}
	return nil
}

func (x *Model_TrainingRun_TrainingOptions) GetL2Regularization() *wrapperspb.DoubleValue {
	if x != nil {
		return x.L2Regularization
	}
	return nil
}

func (x *Model_TrainingRun_TrainingOptions) GetMinRelativeProgress() *wrapperspb.DoubleValue {
	if x != nil {
		return x.MinRelativeProgress
	}
	return nil
}

func (x *Model_TrainingRun_TrainingOptions) GetWarmStart() *wrapperspb.BoolValue {
	if x != nil {
		return x.WarmStart
	}
	return nil
}

func (x *Model_TrainingRun_TrainingOptions) GetEarlyStop() *wrapperspb.BoolValue {
	if x != nil {
		return x.EarlyStop
	}
	return nil
}

func (x *Model_TrainingRun_TrainingOptions) GetInputLabelColumns() []string {
	if x != nil {
		return x.InputLabelColumns
	}
	return nil
}

func (x *Model_TrainingRun_TrainingOptions) GetDataSplitMethod() Model_DataSplitMethod {
	if x != nil {
		return x.DataSplitMethod
	}
	return Model_DATA_SPLIT_METHOD_UNSPECIFIED
}

func (x *Model_TrainingRun_TrainingOptions) GetDataSplitEvalFraction() float64 {
	if x != nil {
		return x.DataSplitEvalFraction
	}
	return 0
}

func (x *Model_TrainingRun_TrainingOptions) GetDataSplitColumn() string {
	if x != nil {
		return x.DataSplitColumn
	}
	return ""
}

func (x *Model_TrainingRun_TrainingOptions) GetLearnRateStrategy() Model_LearnRateStrategy {
	if x != nil {
		return x.LearnRateStrategy
	}
	return Model_LEARN_RATE_STRATEGY_UNSPECIFIED
}

func (x *Model_TrainingRun_TrainingOptions) GetInitialLearnRate() float64 {
	if x != nil {
		return x.InitialLearnRate
	}
	return 0
}

func (x *Model_TrainingRun_TrainingOptions) GetLabelClassWeights() map[string]float64 {
	if x != nil {
		return x.LabelClassWeights
	}
	return nil
}

func (x *Model_TrainingRun_TrainingOptions) GetUserColumn() string {
	if x != nil {
		return x.UserColumn
	}
	return ""
}

func (x *Model_TrainingRun_TrainingOptions) GetItemColumn() string {
	if x != nil {
		return x.ItemColumn
	}
	return ""
}

func (x *Model_TrainingRun_TrainingOptions) GetDistanceType() Model_DistanceType {
	if x != nil {
		return x.DistanceType
	}
	return Model_DISTANCE_TYPE_UNSPECIFIED
}

func (x *Model_TrainingRun_TrainingOptions) GetNumClusters() int64 {
	if x != nil {
		return x.NumClusters
	}
	return 0
}

func (x *Model_TrainingRun_TrainingOptions) GetModelUri() string {
	if x != nil {
		return x.ModelUri
	}
	return ""
}

func (x *Model_TrainingRun_TrainingOptions) GetOptimizationStrategy() Model_OptimizationStrategy {
	if x != nil {
		return x.OptimizationStrategy
	}
	return Model_OPTIMIZATION_STRATEGY_UNSPECIFIED
}

func (x *Model_TrainingRun_TrainingOptions) GetHiddenUnits() []int64 {
	if x != nil {
		return x.HiddenUnits
	}
	return nil
}

func (x *Model_TrainingRun_TrainingOptions) GetBatchSize() int64 {
	if x != nil {
		return x.BatchSize
	}
	return 0
}

func (x *Model_TrainingRun_TrainingOptions) GetDropout() *wrapperspb.DoubleValue {
	if x != nil {
		return x.Dropout
	}
	return nil
}

func (x *Model_TrainingRun_TrainingOptions) GetMaxTreeDepth() int64 {
	if x != nil {
		return x.MaxTreeDepth
	}
	return 0
}

func (x *Model_TrainingRun_TrainingOptions) GetSubsample() float64 {
	if x != nil {
		return x.Subsample
	}
	return 0
}

func (x *Model_TrainingRun_TrainingOptions) GetMinSplitLoss() *wrapperspb.DoubleValue {
	if x != nil {
		return x.MinSplitLoss
	}
	return nil
}

func (x *Model_TrainingRun_TrainingOptions) GetNumFactors() int64 {
	if x != nil {
		return x.NumFactors
	}
	return 0
}

func (x *Model_TrainingRun_TrainingOptions) GetFeedbackType() Model_FeedbackType {
	if x != nil {
		return x.FeedbackType
	}
	return Model_FEEDBACK_TYPE_UNSPECIFIED
}

func (x *Model_TrainingRun_TrainingOptions) GetWalsAlpha() *wrapperspb.DoubleValue {
	if x != nil {
		return x.WalsAlpha
	}
	return nil
}

func (x *Model_TrainingRun_TrainingOptions) GetKmeansInitializationMethod() Model_KmeansEnums_KmeansInitializationMethod {
	if x != nil {
		return x.KmeansInitializationMethod
	}
	return Model_KmeansEnums_KMEANS_INITIALIZATION_METHOD_UNSPECIFIED
}

func (x *Model_TrainingRun_TrainingOptions) GetKmeansInitializationColumn() string {
	if x != nil {
		return x.KmeansInitializationColumn
	}
	return ""
}

func (x *Model_TrainingRun_TrainingOptions) GetTimeSeriesTimestampColumn() string {
	if x != nil {
		return x.TimeSeriesTimestampColumn
	}
	return ""
}

func (x *Model_TrainingRun_TrainingOptions) GetTimeSeriesDataColumn() string {
	if x != nil {
		return x.TimeSeriesDataColumn
	}
	return ""
}

func (x *Model_TrainingRun_TrainingOptions) GetAutoArima() bool {
	if x != nil {
		return x.AutoArima
	}
	return false
}

func (x *Model_TrainingRun_TrainingOptions) GetNonSeasonalOrder() *Model_ArimaOrder {
	if x != nil {
		return x.NonSeasonalOrder
	}
	return nil
}

func (x *Model_TrainingRun_TrainingOptions) GetDataFrequency() Model_DataFrequency {
	if x != nil {
		return x.DataFrequency
	}
	return Model_DATA_FREQUENCY_UNSPECIFIED
}

func (x *Model_TrainingRun_TrainingOptions) GetIncludeDrift() bool {
	if x != nil {
		return x.IncludeDrift
	}
	return false
}

func (x *Model_TrainingRun_TrainingOptions) GetHolidayRegion() Model_HolidayRegion {
	if x != nil {
		return x.HolidayRegion
	}
	return Model_HOLIDAY_REGION_UNSPECIFIED
}

func (x *Model_TrainingRun_TrainingOptions) GetTimeSeriesIdColumn() string {
	if x != nil {
		return x.TimeSeriesIdColumn
	}
	return ""
}

func (x *Model_TrainingRun_TrainingOptions) GetHorizon() int64 {
	if x != nil {
		return x.Horizon
	}
	return 0
}

func (x *Model_TrainingRun_TrainingOptions) GetPreserveInputStructs() bool {
	if x != nil {
		return x.PreserveInputStructs
	}
	return false
}

func (x *Model_TrainingRun_TrainingOptions) GetAutoArimaMaxOrder() int64 {
	if x != nil {
		return x.AutoArimaMaxOrder
	}
	return 0
}

// Information about a single iteration of the training run.
type Model_TrainingRun_IterationResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Index of the iteration, 0 based.
	Index *wrapperspb.Int32Value `protobuf:"bytes,1,opt,name=index,proto3" json:"index,omitempty"`
	// Time taken to run the iteration in milliseconds.
	DurationMs *wrapperspb.Int64Value `protobuf:"bytes,4,opt,name=duration_ms,json=durationMs,proto3" json:"duration_ms,omitempty"`
	// Loss computed on the training data at the end of iteration.
	TrainingLoss *wrapperspb.DoubleValue `protobuf:"bytes,5,opt,name=training_loss,json=trainingLoss,proto3" json:"training_loss,omitempty"`
	// Loss computed on the eval data at the end of iteration.
	EvalLoss *wrapperspb.DoubleValue `protobuf:"bytes,6,opt,name=eval_loss,json=evalLoss,proto3" json:"eval_loss,omitempty"`
	// Learn rate used for this iteration.
	LearnRate float64 `protobuf:"fixed64,7,opt,name=learn_rate,json=learnRate,proto3" json:"learn_rate,omitempty"`
	// Information about top clusters for clustering models.
	ClusterInfos []*Model_TrainingRun_IterationResult_ClusterInfo `protobuf:"bytes,8,rep,name=cluster_infos,json=clusterInfos,proto3" json:"cluster_infos,omitempty"`
	ArimaResult  *Model_TrainingRun_IterationResult_ArimaResult   `protobuf:"bytes,9,opt,name=arima_result,json=arimaResult,proto3" json:"arima_result,omitempty"`
}

func (x *Model_TrainingRun_IterationResult) Reset() {
	*x = Model_TrainingRun_IterationResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_TrainingRun_IterationResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_TrainingRun_IterationResult) ProtoMessage() {}

func (x *Model_TrainingRun_IterationResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_TrainingRun_IterationResult.ProtoReflect.Descriptor instead.
func (*Model_TrainingRun_IterationResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 14, 1}
}

func (x *Model_TrainingRun_IterationResult) GetIndex() *wrapperspb.Int32Value {
	if x != nil {
		return x.Index
	}
	return nil
}

func (x *Model_TrainingRun_IterationResult) GetDurationMs() *wrapperspb.Int64Value {
	if x != nil {
		return x.DurationMs
	}
	return nil
}

func (x *Model_TrainingRun_IterationResult) GetTrainingLoss() *wrapperspb.DoubleValue {
	if x != nil {
		return x.TrainingLoss
	}
	return nil
}

func (x *Model_TrainingRun_IterationResult) GetEvalLoss() *wrapperspb.DoubleValue {
	if x != nil {
		return x.EvalLoss
	}
	return nil
}

func (x *Model_TrainingRun_IterationResult) GetLearnRate() float64 {
	if x != nil {
		return x.LearnRate
	}
	return 0
}

func (x *Model_TrainingRun_IterationResult) GetClusterInfos() []*Model_TrainingRun_IterationResult_ClusterInfo {
	if x != nil {
		return x.ClusterInfos
	}
	return nil
}

func (x *Model_TrainingRun_IterationResult) GetArimaResult() *Model_TrainingRun_IterationResult_ArimaResult {
	if x != nil {
		return x.ArimaResult
	}
	return nil
}

// Information about a single cluster for clustering model.
type Model_TrainingRun_IterationResult_ClusterInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Centroid id.
	CentroidId int64 `protobuf:"varint,1,opt,name=centroid_id,json=centroidId,proto3" json:"centroid_id,omitempty"`
	// Cluster radius, the average distance from centroid
	// to each point assigned to the cluster.
	ClusterRadius *wrapperspb.DoubleValue `protobuf:"bytes,2,opt,name=cluster_radius,json=clusterRadius,proto3" json:"cluster_radius,omitempty"`
	// Cluster size, the total number of points assigned to the cluster.
	ClusterSize *wrapperspb.Int64Value `protobuf:"bytes,3,opt,name=cluster_size,json=clusterSize,proto3" json:"cluster_size,omitempty"`
}

func (x *Model_TrainingRun_IterationResult_ClusterInfo) Reset() {
	*x = Model_TrainingRun_IterationResult_ClusterInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_TrainingRun_IterationResult_ClusterInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_TrainingRun_IterationResult_ClusterInfo) ProtoMessage() {}

func (x *Model_TrainingRun_IterationResult_ClusterInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_TrainingRun_IterationResult_ClusterInfo.ProtoReflect.Descriptor instead.
func (*Model_TrainingRun_IterationResult_ClusterInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 14, 1, 0}
}

func (x *Model_TrainingRun_IterationResult_ClusterInfo) GetCentroidId() int64 {
	if x != nil {
		return x.CentroidId
	}
	return 0
}

func (x *Model_TrainingRun_IterationResult_ClusterInfo) GetClusterRadius() *wrapperspb.DoubleValue {
	if x != nil {
		return x.ClusterRadius
	}
	return nil
}

func (x *Model_TrainingRun_IterationResult_ClusterInfo) GetClusterSize() *wrapperspb.Int64Value {
	if x != nil {
		return x.ClusterSize
	}
	return nil
}

// (Auto-)arima fitting result. Wrap everything in ArimaResult for easier
// refactoring if we want to use model-specific iteration results.
type Model_TrainingRun_IterationResult_ArimaResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This message is repeated because there are multiple arima models
	// fitted in auto-arima. For non-auto-arima model, its size is one.
	ArimaModelInfo []*Model_TrainingRun_IterationResult_ArimaResult_ArimaModelInfo `protobuf:"bytes,1,rep,name=arima_model_info,json=arimaModelInfo,proto3" json:"arima_model_info,omitempty"`
	// Seasonal periods. Repeated because multiple periods are supported for
	// one time series.
	SeasonalPeriods []Model_SeasonalPeriod_SeasonalPeriodType `protobuf:"varint,2,rep,packed,name=seasonal_periods,json=seasonalPeriods,proto3,enum=google.cloud.bigquery.v2.Model_SeasonalPeriod_SeasonalPeriodType" json:"seasonal_periods,omitempty"`
}

func (x *Model_TrainingRun_IterationResult_ArimaResult) Reset() {
	*x = Model_TrainingRun_IterationResult_ArimaResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_TrainingRun_IterationResult_ArimaResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_TrainingRun_IterationResult_ArimaResult) ProtoMessage() {}

func (x *Model_TrainingRun_IterationResult_ArimaResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_TrainingRun_IterationResult_ArimaResult.ProtoReflect.Descriptor instead.
func (*Model_TrainingRun_IterationResult_ArimaResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 14, 1, 1}
}

func (x *Model_TrainingRun_IterationResult_ArimaResult) GetArimaModelInfo() []*Model_TrainingRun_IterationResult_ArimaResult_ArimaModelInfo {
	if x != nil {
		return x.ArimaModelInfo
	}
	return nil
}

func (x *Model_TrainingRun_IterationResult_ArimaResult) GetSeasonalPeriods() []Model_SeasonalPeriod_SeasonalPeriodType {
	if x != nil {
		return x.SeasonalPeriods
	}
	return nil
}

// Arima coefficients.
type Model_TrainingRun_IterationResult_ArimaResult_ArimaCoefficients struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Auto-regressive coefficients, an array of double.
	AutoRegressiveCoefficients []float64 `protobuf:"fixed64,1,rep,packed,name=auto_regressive_coefficients,json=autoRegressiveCoefficients,proto3" json:"auto_regressive_coefficients,omitempty"`
	// Moving-average coefficients, an array of double.
	MovingAverageCoefficients []float64 `protobuf:"fixed64,2,rep,packed,name=moving_average_coefficients,json=movingAverageCoefficients,proto3" json:"moving_average_coefficients,omitempty"`
	// Intercept coefficient, just a double not an array.
	InterceptCoefficient float64 `protobuf:"fixed64,3,opt,name=intercept_coefficient,json=interceptCoefficient,proto3" json:"intercept_coefficient,omitempty"`
}

func (x *Model_TrainingRun_IterationResult_ArimaResult_ArimaCoefficients) Reset() {
	*x = Model_TrainingRun_IterationResult_ArimaResult_ArimaCoefficients{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_TrainingRun_IterationResult_ArimaResult_ArimaCoefficients) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_TrainingRun_IterationResult_ArimaResult_ArimaCoefficients) ProtoMessage() {}

func (x *Model_TrainingRun_IterationResult_ArimaResult_ArimaCoefficients) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_TrainingRun_IterationResult_ArimaResult_ArimaCoefficients.ProtoReflect.Descriptor instead.
func (*Model_TrainingRun_IterationResult_ArimaResult_ArimaCoefficients) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 14, 1, 1, 0}
}

func (x *Model_TrainingRun_IterationResult_ArimaResult_ArimaCoefficients) GetAutoRegressiveCoefficients() []float64 {
	if x != nil {
		return x.AutoRegressiveCoefficients
	}
	return nil
}

func (x *Model_TrainingRun_IterationResult_ArimaResult_ArimaCoefficients) GetMovingAverageCoefficients() []float64 {
	if x != nil {
		return x.MovingAverageCoefficients
	}
	return nil
}

func (x *Model_TrainingRun_IterationResult_ArimaResult_ArimaCoefficients) GetInterceptCoefficient() float64 {
	if x != nil {
		return x.InterceptCoefficient
	}
	return 0
}

// Arima model information.
type Model_TrainingRun_IterationResult_ArimaResult_ArimaModelInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Non-seasonal order.
	NonSeasonalOrder *Model_ArimaOrder `protobuf:"bytes,1,opt,name=non_seasonal_order,json=nonSeasonalOrder,proto3" json:"non_seasonal_order,omitempty"`
	// Arima coefficients.
	ArimaCoefficients *Model_TrainingRun_IterationResult_ArimaResult_ArimaCoefficients `protobuf:"bytes,2,opt,name=arima_coefficients,json=arimaCoefficients,proto3" json:"arima_coefficients,omitempty"`
	// Arima fitting metrics.
	ArimaFittingMetrics *Model_ArimaFittingMetrics `protobuf:"bytes,3,opt,name=arima_fitting_metrics,json=arimaFittingMetrics,proto3" json:"arima_fitting_metrics,omitempty"`
	// Whether Arima model fitted with drift or not. It is always false
	// when d is not 1.
	HasDrift bool `protobuf:"varint,4,opt,name=has_drift,json=hasDrift,proto3" json:"has_drift,omitempty"`
	// The id to indicate different time series.
	TimeSeriesId string `protobuf:"bytes,5,opt,name=time_series_id,json=timeSeriesId,proto3" json:"time_series_id,omitempty"`
	// Seasonal periods. Repeated because multiple periods are supported
	// for one time series.
	SeasonalPeriods []Model_SeasonalPeriod_SeasonalPeriodType `protobuf:"varint,6,rep,packed,name=seasonal_periods,json=seasonalPeriods,proto3,enum=google.cloud.bigquery.v2.Model_SeasonalPeriod_SeasonalPeriodType" json:"seasonal_periods,omitempty"`
}

func (x *Model_TrainingRun_IterationResult_ArimaResult_ArimaModelInfo) Reset() {
	*x = Model_TrainingRun_IterationResult_ArimaResult_ArimaModelInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_TrainingRun_IterationResult_ArimaResult_ArimaModelInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_TrainingRun_IterationResult_ArimaResult_ArimaModelInfo) ProtoMessage() {}

func (x *Model_TrainingRun_IterationResult_ArimaResult_ArimaModelInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_TrainingRun_IterationResult_ArimaResult_ArimaModelInfo.ProtoReflect.Descriptor instead.
func (*Model_TrainingRun_IterationResult_ArimaResult_ArimaModelInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 14, 1, 1, 1}
}

func (x *Model_TrainingRun_IterationResult_ArimaResult_ArimaModelInfo) GetNonSeasonalOrder() *Model_ArimaOrder {
	if x != nil {
		return x.NonSeasonalOrder
	}
	return nil
}

func (x *Model_TrainingRun_IterationResult_ArimaResult_ArimaModelInfo) GetArimaCoefficients() *Model_TrainingRun_IterationResult_ArimaResult_ArimaCoefficients {
	if x != nil {
		return x.ArimaCoefficients
	}
	return nil
}

func (x *Model_TrainingRun_IterationResult_ArimaResult_ArimaModelInfo) GetArimaFittingMetrics() *Model_ArimaFittingMetrics {
	if x != nil {
		return x.ArimaFittingMetrics
	}
	return nil
}

func (x *Model_TrainingRun_IterationResult_ArimaResult_ArimaModelInfo) GetHasDrift() bool {
	if x != nil {
		return x.HasDrift
	}
	return false
}

func (x *Model_TrainingRun_IterationResult_ArimaResult_ArimaModelInfo) GetTimeSeriesId() string {
	if x != nil {
		return x.TimeSeriesId
	}
	return ""
}

func (x *Model_TrainingRun_IterationResult_ArimaResult_ArimaModelInfo) GetSeasonalPeriods() []Model_SeasonalPeriod_SeasonalPeriodType {
	if x != nil {
		return x.SeasonalPeriods
	}
	return nil
}

var File_google_cloud_bigquery_v2_model_proto protoreflect.FileDescriptor

var file_google_cloud_bigquery_v2_model_proto_rawDesc = []byte{
	0x0a, 0x24, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2f, 0x76, 0x32, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32,
	0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61,
	0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2f, 0x76, 0x32, 0x2f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2f, 0x76, 0x32, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2b, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2f, 0x76, 0x32, 0x2f, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x5f,
	0x73, 0x71, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2f, 0x76, 0x32, 0x2f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa4, 0x6e, 0x0a, 0x05, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12,
	0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x56, 0x0a, 0x0f, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x12, 0x28, 0x0a, 0x0d, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x31, 0x0a, 0x12, 0x6c, 0x61,
	0x73, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x6c, 0x61, 0x73,
	0x74, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x25, 0x0a,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0c, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x0d, 0x66, 0x72, 0x69, 0x65, 0x6e, 0x64, 0x6c, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0c, 0x66, 0x72, 0x69, 0x65, 0x6e, 0x64, 0x6c, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x43,
	0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x0f, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x12, 0x2c, 0x0a, 0x0f, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0e, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x1f, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0d, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x6c, 0x0a, 0x18, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x11,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e,
	0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x17, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x4d, 0x0a, 0x0a, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x55, 0x0a, 0x0d, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x75, 0x6e, 0x73,
	0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76,
	0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67,
	0x52, 0x75, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69,
	0x6e, 0x67, 0x52, 0x75, 0x6e, 0x73, 0x12, 0x58, 0x0a, 0x0f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x61, 0x6e, 0x64,
	0x61, 0x72, 0x64, 0x53, 0x71, 0x6c, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0e, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73,
	0x12, 0x54, 0x0a, 0x0d, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e,
	0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x76, 0x32, 0x2e, 0x53, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x53, 0x71, 0x6c, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x43,
	0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x1a, 0xa0, 0x01, 0x0a, 0x0e, 0x53, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x61, 0x6c, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x22, 0x8d, 0x01, 0x0a, 0x12, 0x53, 0x65,
	0x61, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x24, 0x0a, 0x20, 0x53, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x41, 0x4c, 0x5f, 0x50, 0x45, 0x52,
	0x49, 0x4f, 0x44, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x4e, 0x4f, 0x5f, 0x53, 0x45, 0x41,
	0x53, 0x4f, 0x4e, 0x41, 0x4c, 0x49, 0x54, 0x59, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x44, 0x41,
	0x49, 0x4c, 0x59, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x57, 0x45, 0x45, 0x4b, 0x4c, 0x59, 0x10,
	0x03, 0x12, 0x0b, 0x0a, 0x07, 0x4d, 0x4f, 0x4e, 0x54, 0x48, 0x4c, 0x59, 0x10, 0x04, 0x12, 0x0d,
	0x0a, 0x09, 0x51, 0x55, 0x41, 0x52, 0x54, 0x45, 0x52, 0x4c, 0x59, 0x10, 0x05, 0x12, 0x0a, 0x0a,
	0x06, 0x59, 0x45, 0x41, 0x52, 0x4c, 0x59, 0x10, 0x06, 0x1a, 0x87, 0x01, 0x0a, 0x0b, 0x4b, 0x6d,
	0x65, 0x61, 0x6e, 0x73, 0x45, 0x6e, 0x75, 0x6d, 0x73, 0x22, 0x78, 0x0a, 0x1a, 0x4b, 0x6d, 0x65,
	0x61, 0x6e, 0x73, 0x49, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x2c, 0x0a, 0x28, 0x4b, 0x4d, 0x45, 0x41, 0x4e,
	0x53, 0x5f, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x41, 0x4c, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x52, 0x41, 0x4e, 0x44, 0x4f, 0x4d, 0x10,
	0x01, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x10, 0x02, 0x12, 0x14, 0x0a,
	0x10, 0x4b, 0x4d, 0x45, 0x41, 0x4e, 0x53, 0x5f, 0x50, 0x4c, 0x55, 0x53, 0x5f, 0x50, 0x4c, 0x55,
	0x53, 0x10, 0x03, 0x1a, 0x8d, 0x03, 0x0a, 0x11, 0x52, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x4c, 0x0a, 0x13, 0x6d, 0x65, 0x61,
	0x6e, 0x5f, 0x61, 0x62, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x65, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x11, 0x6d, 0x65, 0x61, 0x6e, 0x41, 0x62, 0x73, 0x6f, 0x6c, 0x75,
	0x74, 0x65, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x4a, 0x0a, 0x12, 0x6d, 0x65, 0x61, 0x6e, 0x5f,
	0x73, 0x71, 0x75, 0x61, 0x72, 0x65, 0x64, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x10, 0x6d, 0x65, 0x61, 0x6e, 0x53, 0x71, 0x75, 0x61, 0x72, 0x65, 0x64, 0x45, 0x72,
	0x72, 0x6f, 0x72, 0x12, 0x51, 0x0a, 0x16, 0x6d, 0x65, 0x61, 0x6e, 0x5f, 0x73, 0x71, 0x75, 0x61,
	0x72, 0x65, 0x64, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x13, 0x6d, 0x65, 0x61, 0x6e, 0x53, 0x71, 0x75, 0x61, 0x72, 0x65, 0x64, 0x4c, 0x6f,
	0x67, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x50, 0x0a, 0x15, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x6e,
	0x5f, 0x61, 0x62, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x65, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x13, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x6e, 0x41, 0x62, 0x73, 0x6f, 0x6c,
	0x75, 0x74, 0x65, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x39, 0x0a, 0x09, 0x72, 0x5f, 0x73, 0x71,
	0x75, 0x61, 0x72, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f,
	0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x08, 0x72, 0x53, 0x71, 0x75, 0x61,
	0x72, 0x65, 0x64, 0x1a, 0xb1, 0x03, 0x0a, 0x1e, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74,
	0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x3a, 0x0a, 0x09, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62,
	0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x09, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x34, 0x0a, 0x06, 0x72, 0x65, 0x63, 0x61, 0x6c, 0x6c, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x06, 0x72, 0x65, 0x63, 0x61, 0x6c, 0x6c, 0x12, 0x38, 0x0a, 0x08, 0x61, 0x63, 0x63, 0x75,
	0x72, 0x61, 0x63, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75,
	0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x08, 0x61, 0x63, 0x63, 0x75, 0x72, 0x61,
	0x63, 0x79, 0x12, 0x3a, 0x0a, 0x09, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x09, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x12, 0x37,
	0x0a, 0x08, 0x66, 0x31, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x07,
	0x66, 0x31, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x37, 0x0a, 0x08, 0x6c, 0x6f, 0x67, 0x5f, 0x6c,
	0x6f, 0x73, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62,
	0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x07, 0x6c, 0x6f, 0x67, 0x4c, 0x6f, 0x73, 0x73,
	0x12, 0x35, 0x0a, 0x07, 0x72, 0x6f, 0x63, 0x5f, 0x61, 0x75, 0x63, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x06, 0x72, 0x6f, 0x63, 0x41, 0x75, 0x63, 0x1a, 0xf6, 0x07, 0x0a, 0x1b, 0x42, 0x69, 0x6e, 0x61,
	0x72, 0x79, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x88, 0x01, 0x0a, 0x20, 0x61, 0x67, 0x67, 0x72,
	0x65, 0x67, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x2e, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x61,
	0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x52, 0x1e, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x61,
	0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x12, 0x92, 0x01, 0x0a, 0x1c, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x5f, 0x6c,
	0x69, 0x73, 0x74, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x42, 0x69, 0x6e, 0x61, 0x72,
	0x79, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x42, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x43, 0x6f, 0x6e,
	0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x52, 0x19, 0x62, 0x69,
	0x6e, 0x61, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74,
	0x72, 0x69, 0x78, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x69, 0x76, 0x65, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x25,
	0x0a, 0x0e, 0x6e, 0x65, 0x67, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x67, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x1a, 0xe8, 0x04, 0x0a, 0x15, 0x42, 0x69, 0x6e, 0x61, 0x72, 0x79,
	0x43, 0x6f, 0x6e, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x12,
	0x56, 0x0a, 0x18, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73,
	0x73, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x16, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x54, 0x68,
	0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x12, 0x42, 0x0a, 0x0e, 0x74, 0x72, 0x75, 0x65, 0x5f,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0d, 0x74, 0x72,
	0x75, 0x65, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x73, 0x12, 0x44, 0x0a, 0x0f, 0x66,
	0x61, 0x6c, 0x73, 0x65, 0x5f, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x73, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x0e, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65,
	0x73, 0x12, 0x42, 0x0a, 0x0e, 0x74, 0x72, 0x75, 0x65, 0x5f, 0x6e, 0x65, 0x67, 0x61, 0x74, 0x69,
	0x76, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36,
	0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0d, 0x74, 0x72, 0x75, 0x65, 0x4e, 0x65, 0x67, 0x61,
	0x74, 0x69, 0x76, 0x65, 0x73, 0x12, 0x44, 0x0a, 0x0f, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x5f, 0x6e,
	0x65, 0x67, 0x61, 0x74, 0x69, 0x76, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x66, 0x61, 0x6c,
	0x73, 0x65, 0x4e, 0x65, 0x67, 0x61, 0x74, 0x69, 0x76, 0x65, 0x73, 0x12, 0x3a, 0x0a, 0x09, 0x70,
	0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x09, 0x70, 0x72,
	0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x34, 0x0a, 0x06, 0x72, 0x65, 0x63, 0x61, 0x6c,
	0x6c, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x72, 0x65, 0x63, 0x61, 0x6c, 0x6c, 0x12, 0x37, 0x0a,
	0x08, 0x66, 0x31, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x07, 0x66,
	0x31, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x38, 0x0a, 0x08, 0x61, 0x63, 0x63, 0x75, 0x72, 0x61,
	0x63, 0x79, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c,
	0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x08, 0x61, 0x63, 0x63, 0x75, 0x72, 0x61, 0x63, 0x79,
	0x1a, 0x8a, 0x06, 0x0a, 0x1f, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x43,
	0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x12, 0x88, 0x01, 0x0a, 0x20, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61,
	0x74, 0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x2e, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52,
	0x1e, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12,
	0x83, 0x01, 0x0a, 0x15, 0x63, 0x6f, 0x6e, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61,
	0x74, 0x72, 0x69, 0x78, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x4f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x2e, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x43, 0x6c, 0x61, 0x73, 0x73,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x72, 0x69, 0x78,
	0x52, 0x13, 0x63, 0x6f, 0x6e, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x72, 0x69,
	0x78, 0x4c, 0x69, 0x73, 0x74, 0x1a, 0xd5, 0x03, 0x0a, 0x0f, 0x43, 0x6f, 0x6e, 0x66, 0x75, 0x73,
	0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x12, 0x4f, 0x0a, 0x14, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x13, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63,
	0x65, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x12, 0x67, 0x0a, 0x04, 0x72, 0x6f,
	0x77, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x53, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x43,
	0x6c, 0x61, 0x73, 0x73, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x75, 0x73,
	0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x2e, 0x52, 0x6f, 0x77, 0x52, 0x04, 0x72,
	0x6f, 0x77, 0x73, 0x1a, 0x6c, 0x0a, 0x05, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x27, 0x0a, 0x0f,
	0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x65, 0x64,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x3a, 0x0a, 0x0a, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36,
	0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x09, 0x69, 0x74, 0x65, 0x6d, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x1a, 0x99, 0x01, 0x0a, 0x03, 0x52, 0x6f, 0x77, 0x12, 0x21, 0x0a, 0x0c, 0x61, 0x63, 0x74,
	0x75, 0x61, 0x6c, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x61, 0x63, 0x74, 0x75, 0x61, 0x6c, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x6f, 0x0a, 0x07,
	0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x55, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x4d,
	0x75, 0x6c, 0x74, 0x69, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x43,
	0x6f, 0x6e, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x2e, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x1a, 0xf4, 0x07,
	0x0a, 0x11, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x12, 0x4e, 0x0a, 0x14, 0x64, 0x61, 0x76, 0x69, 0x65, 0x73, 0x5f, 0x62, 0x6f,
	0x75, 0x6c, 0x64, 0x69, 0x6e, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x12, 0x64, 0x61, 0x76, 0x69, 0x65, 0x73, 0x42, 0x6f, 0x75, 0x6c, 0x64, 0x69, 0x6e, 0x49, 0x6e,
	0x64, 0x65, 0x78, 0x12, 0x50, 0x0a, 0x15, 0x6d, 0x65, 0x61, 0x6e, 0x5f, 0x73, 0x71, 0x75, 0x61,
	0x72, 0x65, 0x64, 0x5f, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x13, 0x6d, 0x65, 0x61, 0x6e, 0x53, 0x71, 0x75, 0x61, 0x72, 0x65, 0x64, 0x44, 0x69, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x55, 0x0a, 0x08, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x52, 0x08, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x1a, 0xe5, 0x05, 0x0a,
	0x07, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x65, 0x6e, 0x74,
	0x72, 0x6f, 0x69, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x63,
	0x65, 0x6e, 0x74, 0x72, 0x6f, 0x69, 0x64, 0x49, 0x64, 0x12, 0x6d, 0x0a, 0x0e, 0x66, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x46, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0d, 0x66, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x31, 0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0x96, 0x04, 0x0a, 0x0c,
	0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x25, 0x0a, 0x0e,
	0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x6c,
	0x75, 0x6d, 0x6e, 0x12, 0x47, 0x0a, 0x0f, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x61, 0x6c,
	0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x48, 0x00, 0x52, 0x0e, 0x6e, 0x75,
	0x6d, 0x65, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x86, 0x01, 0x0a,
	0x11, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x57, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x2e, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x48, 0x00, 0x52, 0x10, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0x83, 0x02, 0x0a, 0x10, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f,
	0x72, 0x69, 0x63, 0x61, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x8e, 0x01, 0x0a, 0x0f, 0x63,
	0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x67,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e,
	0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x2e, 0x43, 0x61, 0x74,
	0x65, 0x67, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x2e, 0x43, 0x61,
	0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x0e, 0x63, 0x61, 0x74,
	0x65, 0x67, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x1a, 0x5e, 0x0a, 0x0d, 0x43,
	0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x1a, 0x0a, 0x08,
	0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x31, 0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x07, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x1a, 0xe2, 0x02, 0x0a, 0x0e, 0x52, 0x61, 0x6e, 0x6b, 0x69, 0x6e, 0x67,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x52, 0x0a, 0x16, 0x6d, 0x65, 0x61, 0x6e, 0x5f,
	0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x14, 0x6d, 0x65, 0x61, 0x6e, 0x41, 0x76, 0x65, 0x72, 0x61,
	0x67, 0x65, 0x50, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x4a, 0x0a, 0x12, 0x6d,
	0x65, 0x61, 0x6e, 0x5f, 0x73, 0x71, 0x75, 0x61, 0x72, 0x65, 0x64, 0x5f, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x10, 0x6d, 0x65, 0x61, 0x6e, 0x53, 0x71, 0x75, 0x61, 0x72,
	0x65, 0x64, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x6f, 0x0a, 0x25, 0x6e, 0x6f, 0x72, 0x6d, 0x61,
	0x6c, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x64,
	0x5f, 0x63, 0x75, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x67, 0x61, 0x69, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x22, 0x6e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64,
	0x44, 0x69, 0x73, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x64, 0x43, 0x75, 0x6d, 0x75, 0x6c, 0x61,
	0x74, 0x69, 0x76, 0x65, 0x47, 0x61, 0x69, 0x6e, 0x12, 0x3f, 0x0a, 0x0c, 0x61, 0x76, 0x65, 0x72,
	0x61, 0x67, 0x65, 0x5f, 0x72, 0x61, 0x6e, 0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0b, 0x61, 0x76,
	0x65, 0x72, 0x61, 0x67, 0x65, 0x52, 0x61, 0x6e, 0x6b, 0x1a, 0xd9, 0x07, 0x0a, 0x17, 0x41, 0x72,
	0x69, 0x6d, 0x61, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x58, 0x0a, 0x12, 0x6e, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x61,
	0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x2e, 0x41, 0x72, 0x69, 0x6d, 0x61, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x52, 0x10, 0x6e,
	0x6f, 0x6e, 0x53, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x12,
	0x67, 0x0a, 0x15, 0x61, 0x72, 0x69, 0x6d, 0x61, 0x5f, 0x66, 0x69, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e,
	0x41, 0x72, 0x69, 0x6d, 0x61, 0x46, 0x69, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x52, 0x13, 0x61, 0x72, 0x69, 0x6d, 0x61, 0x46, 0x69, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x6c, 0x0a, 0x10, 0x73, 0x65, 0x61, 0x73,
	0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0e, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x2e, 0x53, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x50, 0x65, 0x72, 0x69,
	0x6f, 0x64, 0x2e, 0x53, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x50, 0x65, 0x72, 0x69, 0x6f,
	0x64, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0f, 0x73, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x50,
	0x65, 0x72, 0x69, 0x6f, 0x64, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x68, 0x61, 0x73, 0x5f, 0x64, 0x72,
	0x69, 0x66, 0x74, 0x18, 0x04, 0x20, 0x03, 0x28, 0x08, 0x52, 0x08, 0x68, 0x61, 0x73, 0x44, 0x72,
	0x69, 0x66, 0x74, 0x12, 0x24, 0x0a, 0x0e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x69,
	0x65, 0x73, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x74, 0x69, 0x6d,
	0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x49, 0x64, 0x12, 0xae, 0x01, 0x0a, 0x26, 0x61, 0x72,
	0x69, 0x6d, 0x61, 0x5f, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x5f, 0x66, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x5a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x41, 0x72, 0x69, 0x6d,
	0x61, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x2e, 0x41, 0x72, 0x69, 0x6d, 0x61, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x22, 0x61, 0x72, 0x69, 0x6d, 0x61, 0x53, 0x69, 0x6e,
	0x67, 0x6c, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74,
	0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x1a, 0x98, 0x03, 0x0a, 0x22, 0x41,
	0x72, 0x69, 0x6d, 0x61, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x46,
	0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x12, 0x58, 0x0a, 0x12, 0x6e, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x61,
	0x6c, 0x5f, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x41,
	0x72, 0x69, 0x6d, 0x61, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x52, 0x10, 0x6e, 0x6f, 0x6e, 0x53, 0x65,
	0x61, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x12, 0x67, 0x0a, 0x15, 0x61,
	0x72, 0x69, 0x6d, 0x61, 0x5f, 0x66, 0x69, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x41, 0x72, 0x69, 0x6d,
	0x61, 0x46, 0x69, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52,
	0x13, 0x61, 0x72, 0x69, 0x6d, 0x61, 0x46, 0x69, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x68, 0x61, 0x73, 0x5f, 0x64, 0x72, 0x69, 0x66,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x68, 0x61, 0x73, 0x44, 0x72, 0x69, 0x66,
	0x74, 0x12, 0x24, 0x0a, 0x0e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73,
	0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x74, 0x69, 0x6d, 0x65, 0x53,
	0x65, 0x72, 0x69, 0x65, 0x73, 0x49, 0x64, 0x12, 0x6c, 0x0a, 0x10, 0x73, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x61, 0x6c, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28,
	0x0e, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x2e, 0x53, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x50, 0x65, 0x72, 0x69, 0x6f,
	0x64, 0x2e, 0x53, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x0f, 0x73, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x50, 0x65,
	0x72, 0x69, 0x6f, 0x64, 0x73, 0x1a, 0xcd, 0x05, 0x0a, 0x11, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x62, 0x0a, 0x12, 0x72,
	0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x52, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x48, 0x00, 0x52, 0x11, 0x72, 0x65,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12,
	0x81, 0x01, 0x0a, 0x1d, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x42, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x43,
	0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x48, 0x00, 0x52, 0x1b, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x43, 0x6c,
	0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x12, 0x8e, 0x01, 0x0a, 0x22, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x5f, 0x63, 0x6c,
	0x61, 0x73, 0x73, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x2e, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x43, 0x6c, 0x61, 0x73,
	0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x48, 0x00, 0x52, 0x1f, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x43,
	0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x12, 0x62, 0x0a, 0x12, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x67, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x48, 0x00, 0x52, 0x11, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x69, 0x6e,
	0x67, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x59, 0x0a, 0x0f, 0x72, 0x61, 0x6e, 0x6b,
	0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x2e, 0x52, 0x61, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x48, 0x00, 0x52, 0x0e, 0x72, 0x61, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x12, 0x75, 0x0a, 0x19, 0x61, 0x72, 0x69, 0x6d, 0x61, 0x5f, 0x66, 0x6f, 0x72,
	0x65, 0x63, 0x61, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76,
	0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x41, 0x72, 0x69, 0x6d, 0x61, 0x46, 0x6f, 0x72,
	0x65, 0x63, 0x61, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x48,
	0x00, 0x52, 0x17, 0x61, 0x72, 0x69, 0x6d, 0x61, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74,
	0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x42, 0x09, 0x0a, 0x07, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x1a, 0xb7, 0x01, 0x0a, 0x0f, 0x44, 0x61, 0x74, 0x61, 0x53, 0x70,
	0x6c, 0x69, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x4f, 0x0a, 0x0e, 0x74, 0x72, 0x61,
	0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x61, 0x62,
	0x6c, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x0d, 0x74, 0x72, 0x61,
	0x69, 0x6e, 0x69, 0x6e, 0x67, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x53, 0x0a, 0x10, 0x65, 0x76,
	0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e,
	0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x0f,
	0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x1a,
	0x36, 0x0a, 0x0a, 0x41, 0x72, 0x69, 0x6d, 0x61, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x12, 0x0c, 0x0a,
	0x01, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x01, 0x70, 0x12, 0x0c, 0x0a, 0x01, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x01, 0x64, 0x12, 0x0c, 0x0a, 0x01, 0x71, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x01, 0x71, 0x1a, 0x6a, 0x0a, 0x13, 0x41, 0x72, 0x69, 0x6d, 0x61,
	0x46, 0x69, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x25,
	0x0a, 0x0e, 0x6c, 0x6f, 0x67, 0x5f, 0x6c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0d, 0x6c, 0x6f, 0x67, 0x4c, 0x69, 0x6b, 0x65, 0x6c,
	0x69, 0x68, 0x6f, 0x6f, 0x64, 0x12, 0x10, 0x0a, 0x03, 0x61, 0x69, 0x63, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x01, 0x52, 0x03, 0x61, 0x69, 0x63, 0x12, 0x1a, 0x0a, 0x08, 0x76, 0x61, 0x72, 0x69, 0x61,
	0x6e, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x52, 0x08, 0x76, 0x61, 0x72, 0x69, 0x61,
	0x6e, 0x63, 0x65, 0x1a, 0x89, 0x02, 0x0a, 0x11, 0x47, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x45, 0x78,
	0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x61, 0x0a, 0x0c, 0x65, 0x78, 0x70,
	0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x2e, 0x47, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c,
	0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1f, 0x0a, 0x0b,
	0x63, 0x6c, 0x61, 0x73, 0x73, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x1a, 0x70, 0x0a,
	0x0b, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x0c,
	0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x3e, 0x0a, 0x0b, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x0b, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x1a,
	0xbf, 0x26, 0x0a, 0x0b, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6e, 0x12,
	0x66, 0x0a, 0x10, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x6f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x54, 0x72, 0x61, 0x69, 0x6e,
	0x69, 0x6e, 0x67, 0x52, 0x75, 0x6e, 0x2e, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x0f, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x55, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x06, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6e,
	0x2e, 0x49, 0x74, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x52, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x60, 0x0a, 0x12, 0x65, 0x76, 0x61,
	0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32,
	0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x11, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x5b, 0x0a, 0x11, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76,
	0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x70, 0x6c, 0x69,
	0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x0f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x70, 0x6c,
	0x69, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x62, 0x0a, 0x13, 0x67, 0x6c, 0x6f, 0x62,
	0x61, 0x6c, 0x5f, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32,
	0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x47, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x45, 0x78, 0x70,
	0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x12, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c,
	0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x80, 0x15, 0x0a,
	0x0f, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x25, 0x0a, 0x0e, 0x6d, 0x61, 0x78, 0x5f, 0x69, 0x74, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x6d, 0x61, 0x78, 0x49, 0x74, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x45, 0x0a, 0x09, 0x6c, 0x6f, 0x73, 0x73, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x4c, 0x6f, 0x73, 0x73,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x08, 0x6c, 0x6f, 0x73, 0x73, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d,
	0x0a, 0x0a, 0x6c, 0x65, 0x61, 0x72, 0x6e, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x01, 0x52, 0x09, 0x6c, 0x65, 0x61, 0x72, 0x6e, 0x52, 0x61, 0x74, 0x65, 0x12, 0x49, 0x0a,
	0x11, 0x6c, 0x31, 0x5f, 0x72, 0x65, 0x67, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c,
	0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x10, 0x6c, 0x31, 0x52, 0x65, 0x67, 0x75, 0x6c, 0x61,
	0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x49, 0x0a, 0x11, 0x6c, 0x32, 0x5f, 0x72,
	0x65, 0x67, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x10, 0x6c, 0x32, 0x52, 0x65, 0x67, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x50, 0x0a, 0x15, 0x6d, 0x69, 0x6e, 0x5f, 0x72, 0x65, 0x6c, 0x61, 0x74,
	0x69, 0x76, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x13, 0x6d, 0x69, 0x6e, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x50, 0x72, 0x6f,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x39, 0x0a, 0x0a, 0x77, 0x61, 0x72, 0x6d, 0x5f, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x09, 0x77, 0x61, 0x72, 0x6d, 0x53, 0x74, 0x61, 0x72, 0x74,
	0x12, 0x39, 0x0a, 0x0a, 0x65, 0x61, 0x72, 0x6c, 0x79, 0x5f, 0x73, 0x74, 0x6f, 0x70, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x09, 0x65, 0x61, 0x72, 0x6c, 0x79, 0x53, 0x74, 0x6f, 0x70, 0x12, 0x2e, 0x0a, 0x13, 0x69,
	0x6e, 0x70, 0x75, 0x74, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d,
	0x6e, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x09, 0x52, 0x11, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x12, 0x5b, 0x0a, 0x11, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76,
	0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x70, 0x6c, 0x69,
	0x74, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x52, 0x0f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x70, 0x6c,
	0x69, 0x74, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x37, 0x0a, 0x18, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x5f, 0x65, 0x76, 0x61, 0x6c, 0x5f, 0x66, 0x72, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x01, 0x52, 0x15, 0x64, 0x61, 0x74, 0x61,
	0x53, 0x70, 0x6c, 0x69, 0x74, 0x45, 0x76, 0x61, 0x6c, 0x46, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x2a, 0x0a, 0x11, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x5f,
	0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x64, 0x61,
	0x74, 0x61, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x12, 0x61, 0x0a,
	0x13, 0x6c, 0x65, 0x61, 0x72, 0x6e, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x73, 0x74, 0x72, 0x61,
	0x74, 0x65, 0x67, 0x79, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x4c, 0x65, 0x61, 0x72,
	0x6e, 0x52, 0x61, 0x74, 0x65, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x52, 0x11, 0x6c,
	0x65, 0x61, 0x72, 0x6e, 0x52, 0x61, 0x74, 0x65, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79,
	0x12, 0x2c, 0x0a, 0x12, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x6c, 0x65, 0x61, 0x72,
	0x6e, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x01, 0x52, 0x10, 0x69, 0x6e,
	0x69, 0x74, 0x69, 0x61, 0x6c, 0x4c, 0x65, 0x61, 0x72, 0x6e, 0x52, 0x61, 0x74, 0x65, 0x12, 0x82,
	0x01, 0x0a, 0x13, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x5f, 0x77,
	0x65, 0x69, 0x67, 0x68, 0x74, 0x73, 0x18, 0x11, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x52, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x54, 0x72,
	0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6e, 0x2e, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69,
	0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x43,
	0x6c, 0x61, 0x73, 0x73, 0x57, 0x65, 0x69, 0x67, 0x68, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x11, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x57, 0x65, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6c, 0x75,
	0x6d, 0x6e, 0x18, 0x12, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x75, 0x73, 0x65, 0x72, 0x43, 0x6f,
	0x6c, 0x75, 0x6d, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x63, 0x6f, 0x6c,
	0x75, 0x6d, 0x6e, 0x18, 0x13, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x69, 0x74, 0x65, 0x6d, 0x43,
	0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x12, 0x51, 0x0a, 0x0d, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x44, 0x69,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0c, 0x64, 0x69, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x6e, 0x75, 0x6d, 0x5f,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x18, 0x15, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0b,
	0x6e, 0x75, 0x6d, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x16, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x55, 0x72, 0x69, 0x12, 0x69, 0x0a, 0x15, 0x6f, 0x70, 0x74, 0x69,
	0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67,
	0x79, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x4f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x52, 0x14, 0x6f,
	0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x61, 0x74,
	0x65, 0x67, 0x79, 0x12, 0x21, 0x0a, 0x0c, 0x68, 0x69, 0x64, 0x64, 0x65, 0x6e, 0x5f, 0x75, 0x6e,
	0x69, 0x74, 0x73, 0x18, 0x18, 0x20, 0x03, 0x28, 0x03, 0x52, 0x0b, 0x68, 0x69, 0x64, 0x64, 0x65,
	0x6e, 0x55, 0x6e, 0x69, 0x74, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x19, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x62, 0x61, 0x74, 0x63,
	0x68, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x36, 0x0a, 0x07, 0x64, 0x72, 0x6f, 0x70, 0x6f, 0x75, 0x74,
	0x18, 0x1a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x07, 0x64, 0x72, 0x6f, 0x70, 0x6f, 0x75, 0x74, 0x12, 0x24, 0x0a,
	0x0e, 0x6d, 0x61, 0x78, 0x5f, 0x74, 0x72, 0x65, 0x65, 0x5f, 0x64, 0x65, 0x70, 0x74, 0x68, 0x18,
	0x1b, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0c, 0x6d, 0x61, 0x78, 0x54, 0x72, 0x65, 0x65, 0x44, 0x65,
	0x70, 0x74, 0x68, 0x12, 0x1c, 0x0a, 0x09, 0x73, 0x75, 0x62, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x18, 0x1c, 0x20, 0x01, 0x28, 0x01, 0x52, 0x09, 0x73, 0x75, 0x62, 0x73, 0x61, 0x6d, 0x70, 0x6c,
	0x65, 0x12, 0x42, 0x0a, 0x0e, 0x6d, 0x69, 0x6e, 0x5f, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x5f, 0x6c,
	0x6f, 0x73, 0x73, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62,
	0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c, 0x6d, 0x69, 0x6e, 0x53, 0x70, 0x6c, 0x69,
	0x74, 0x4c, 0x6f, 0x73, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x6e, 0x75, 0x6d, 0x5f, 0x66, 0x61, 0x63,
	0x74, 0x6f, 0x72, 0x73, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x6e, 0x75, 0x6d, 0x46,
	0x61, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x12, 0x51, 0x0a, 0x0d, 0x66, 0x65, 0x65, 0x64, 0x62, 0x61,
	0x63, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x1f, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x46,
	0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0c, 0x66, 0x65, 0x65,
	0x64, 0x62, 0x61, 0x63, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12, 0x3b, 0x0a, 0x0a, 0x77, 0x61, 0x6c,
	0x73, 0x5f, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x18, 0x20, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x09, 0x77, 0x61, 0x6c,
	0x73, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x12, 0x88, 0x01, 0x0a, 0x1c, 0x6b, 0x6d, 0x65, 0x61, 0x6e,
	0x73, 0x5f, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x18, 0x21, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x46, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x4b,
	0x6d, 0x65, 0x61, 0x6e, 0x73, 0x45, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x4b, 0x6d, 0x65, 0x61, 0x6e,
	0x73, 0x49, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x68, 0x6f, 0x64, 0x52, 0x1a, 0x6b, 0x6d, 0x65, 0x61, 0x6e, 0x73, 0x49, 0x6e, 0x69,
	0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x68, 0x6f,
	0x64, 0x12, 0x40, 0x0a, 0x1c, 0x6b, 0x6d, 0x65, 0x61, 0x6e, 0x73, 0x5f, 0x69, 0x6e, 0x69, 0x74,
	0x69, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d,
	0x6e, 0x18, 0x22, 0x20, 0x01, 0x28, 0x09, 0x52, 0x1a, 0x6b, 0x6d, 0x65, 0x61, 0x6e, 0x73, 0x49,
	0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6c,
	0x75, 0x6d, 0x6e, 0x12, 0x3f, 0x0a, 0x1c, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x69,
	0x65, 0x73, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x5f, 0x63, 0x6f, 0x6c,
	0x75, 0x6d, 0x6e, 0x18, 0x23, 0x20, 0x01, 0x28, 0x09, 0x52, 0x19, 0x74, 0x69, 0x6d, 0x65, 0x53,
	0x65, 0x72, 0x69, 0x65, 0x73, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x43, 0x6f,
	0x6c, 0x75, 0x6d, 0x6e, 0x12, 0x35, 0x0a, 0x17, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72,
	0x69, 0x65, 0x73, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x18,
	0x24, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65,
	0x73, 0x44, 0x61, 0x74, 0x61, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x61,
	0x75, 0x74, 0x6f, 0x5f, 0x61, 0x72, 0x69, 0x6d, 0x61, 0x18, 0x25, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x09, 0x61, 0x75, 0x74, 0x6f, 0x41, 0x72, 0x69, 0x6d, 0x61, 0x12, 0x58, 0x0a, 0x12, 0x6e, 0x6f,
	0x6e, 0x5f, 0x73, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x6f, 0x72, 0x64, 0x65, 0x72,
	0x18, 0x26, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76,
	0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x41, 0x72, 0x69, 0x6d, 0x61, 0x4f, 0x72, 0x64,
	0x65, 0x72, 0x52, 0x10, 0x6e, 0x6f, 0x6e, 0x53, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x4f,
	0x72, 0x64, 0x65, 0x72, 0x12, 0x54, 0x0a, 0x0e, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x66, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x27, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x52, 0x0d, 0x64, 0x61, 0x74,
	0x61, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x6e,
	0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x64, 0x72, 0x69, 0x66, 0x74, 0x18, 0x29, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0c, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x44, 0x72, 0x69, 0x66, 0x74, 0x12,
	0x54, 0x0a, 0x0e, 0x68, 0x6f, 0x6c, 0x69, 0x64, 0x61, 0x79, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f,
	0x6e, 0x18, 0x2a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x48, 0x6f, 0x6c, 0x69, 0x64, 0x61, 0x79,
	0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x68, 0x6f, 0x6c, 0x69, 0x64, 0x61, 0x79, 0x52,
	0x65, 0x67, 0x69, 0x6f, 0x6e, 0x12, 0x31, 0x0a, 0x15, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65,
	0x72, 0x69, 0x65, 0x73, 0x5f, 0x69, 0x64, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x18, 0x2b,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73,
	0x49, 0x64, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x68, 0x6f, 0x72, 0x69,
	0x7a, 0x6f, 0x6e, 0x18, 0x2c, 0x20, 0x01, 0x28, 0x03, 0x52, 0x07, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x6f, 0x6e, 0x12, 0x34, 0x0a, 0x16, 0x70, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x5f, 0x69,
	0x6e, 0x70, 0x75, 0x74, 0x5f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x73, 0x18, 0x2d, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x14, 0x70, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x49, 0x6e, 0x70, 0x75,
	0x74, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x73, 0x12, 0x2f, 0x0a, 0x14, 0x61, 0x75, 0x74, 0x6f,
	0x5f, 0x61, 0x72, 0x69, 0x6d, 0x61, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x6f, 0x72, 0x64, 0x65, 0x72,
	0x18, 0x2e, 0x20, 0x01, 0x28, 0x03, 0x52, 0x11, 0x61, 0x75, 0x74, 0x6f, 0x41, 0x72, 0x69, 0x6d,
	0x61, 0x4d, 0x61, 0x78, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x1a, 0x44, 0x0a, 0x16, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x57, 0x65, 0x69, 0x67, 0x68, 0x74, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x01, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a,
	0x8f, 0x0d, 0x0a, 0x0f, 0x49, 0x74, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x12, 0x31, 0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x3c, 0x0a, 0x0b, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x6d, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e,
	0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x73, 0x12, 0x41, 0x0a, 0x0d, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67,
	0x5f, 0x6c, 0x6f, 0x73, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f,
	0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c, 0x74, 0x72, 0x61, 0x69, 0x6e,
	0x69, 0x6e, 0x67, 0x4c, 0x6f, 0x73, 0x73, 0x12, 0x39, 0x0a, 0x09, 0x65, 0x76, 0x61, 0x6c, 0x5f,
	0x6c, 0x6f, 0x73, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75,
	0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x08, 0x65, 0x76, 0x61, 0x6c, 0x4c, 0x6f,
	0x73, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x6c, 0x65, 0x61, 0x72, 0x6e, 0x5f, 0x72, 0x61, 0x74, 0x65,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x01, 0x52, 0x09, 0x6c, 0x65, 0x61, 0x72, 0x6e, 0x52, 0x61, 0x74,
	0x65, 0x12, 0x6c, 0x0a, 0x0d, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x66,
	0x6f, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69,
	0x6e, 0x67, 0x52, 0x75, 0x6e, 0x2e, 0x49, 0x74, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x6e, 0x66,
	0x6f, 0x52, 0x0c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x73, 0x12,
	0x6a, 0x0a, 0x0c, 0x61, 0x72, 0x69, 0x6d, 0x61, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32,
	0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x52,
	0x75, 0x6e, 0x2e, 0x49, 0x74, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x2e, 0x41, 0x72, 0x69, 0x6d, 0x61, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x0b,
	0x61, 0x72, 0x69, 0x6d, 0x61, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x1a, 0xb3, 0x01, 0x0a, 0x0b,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1f, 0x0a, 0x0b, 0x63,
	0x65, 0x6e, 0x74, 0x72, 0x6f, 0x69, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x0a, 0x63, 0x65, 0x6e, 0x74, 0x72, 0x6f, 0x69, 0x64, 0x49, 0x64, 0x12, 0x43, 0x0a, 0x0e,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x72, 0x61, 0x64, 0x69, 0x75, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x0d, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x61, 0x64, 0x69, 0x75,
	0x73, 0x12, 0x3e, 0x0a, 0x0c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x0b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53, 0x69, 0x7a,
	0x65, 0x1a, 0xdd, 0x07, 0x0a, 0x0b, 0x41, 0x72, 0x69, 0x6d, 0x61, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x12, 0x80, 0x01, 0x0a, 0x10, 0x61, 0x72, 0x69, 0x6d, 0x61, 0x5f, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x56, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x54, 0x72,
	0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6e, 0x2e, 0x49, 0x74, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x41, 0x72, 0x69, 0x6d, 0x61, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x41, 0x72, 0x69, 0x6d, 0x61, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0e, 0x61, 0x72, 0x69, 0x6d, 0x61, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x6c, 0x0a, 0x10, 0x73, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x61, 0x6c,
	0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x41,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e,
	0x53, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x2e, 0x53,
	0x65, 0x61, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x0f, 0x73, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x50, 0x65, 0x72, 0x69, 0x6f,
	0x64, 0x73, 0x1a, 0xca, 0x01, 0x0a, 0x11, 0x41, 0x72, 0x69, 0x6d, 0x61, 0x43, 0x6f, 0x65, 0x66,
	0x66, 0x69, 0x63, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x40, 0x0a, 0x1c, 0x61, 0x75, 0x74, 0x6f,
	0x5f, 0x72, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x6f, 0x65, 0x66,
	0x66, 0x69, 0x63, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x01, 0x52, 0x1a,
	0x61, 0x75, 0x74, 0x6f, 0x52, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x69, 0x76, 0x65, 0x43, 0x6f,
	0x65, 0x66, 0x66, 0x69, 0x63, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x3e, 0x0a, 0x1b, 0x6d, 0x6f,
	0x76, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x65,
	0x66, 0x66, 0x69, 0x63, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x01, 0x52,
	0x19, 0x6d, 0x6f, 0x76, 0x69, 0x6e, 0x67, 0x41, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6f,
	0x65, 0x66, 0x66, 0x69, 0x63, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x33, 0x0a, 0x15, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x63, 0x65, 0x70, 0x74, 0x5f, 0x63, 0x6f, 0x65, 0x66, 0x66, 0x69, 0x63, 0x69,
	0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x52, 0x14, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x63, 0x65, 0x70, 0x74, 0x43, 0x6f, 0x65, 0x66, 0x66, 0x69, 0x63, 0x69, 0x65, 0x6e, 0x74, 0x1a,
	0x8f, 0x04, 0x0a, 0x0e, 0x41, 0x72, 0x69, 0x6d, 0x61, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x58, 0x0a, 0x12, 0x6e, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x61, 0x73, 0x6f, 0x6e,
	0x61, 0x6c, 0x5f, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e,
	0x41, 0x72, 0x69, 0x6d, 0x61, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x52, 0x10, 0x6e, 0x6f, 0x6e, 0x53,
	0x65, 0x61, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x12, 0x88, 0x01, 0x0a,
	0x12, 0x61, 0x72, 0x69, 0x6d, 0x61, 0x5f, 0x63, 0x6f, 0x65, 0x66, 0x66, 0x69, 0x63, 0x69, 0x65,
	0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x59, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x54, 0x72, 0x61, 0x69, 0x6e,
	0x69, 0x6e, 0x67, 0x52, 0x75, 0x6e, 0x2e, 0x49, 0x74, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x41, 0x72, 0x69, 0x6d, 0x61, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x2e, 0x41, 0x72, 0x69, 0x6d, 0x61, 0x43, 0x6f, 0x65, 0x66, 0x66, 0x69, 0x63, 0x69,
	0x65, 0x6e, 0x74, 0x73, 0x52, 0x11, 0x61, 0x72, 0x69, 0x6d, 0x61, 0x43, 0x6f, 0x65, 0x66, 0x66,
	0x69, 0x63, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x67, 0x0a, 0x15, 0x61, 0x72, 0x69, 0x6d, 0x61,
	0x5f, 0x66, 0x69, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76,
	0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x41, 0x72, 0x69, 0x6d, 0x61, 0x46, 0x69, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x13, 0x61, 0x72, 0x69,
	0x6d, 0x61, 0x46, 0x69, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x12, 0x1b, 0x0a, 0x09, 0x68, 0x61, 0x73, 0x5f, 0x64, 0x72, 0x69, 0x66, 0x74, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x08, 0x68, 0x61, 0x73, 0x44, 0x72, 0x69, 0x66, 0x74, 0x12, 0x24, 0x0a,
	0x0e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x5f, 0x69, 0x64, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65,
	0x73, 0x49, 0x64, 0x12, 0x6c, 0x0a, 0x10, 0x73, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x5f,
	0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x41, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x53,
	0x65, 0x61, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x2e, 0x53, 0x65,
	0x61, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x0f, 0x73, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64,
	0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xa5, 0x02, 0x0a,
	0x09, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x4d, 0x4f,
	0x44, 0x45, 0x4c, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x4c, 0x49, 0x4e, 0x45, 0x41, 0x52,
	0x5f, 0x52, 0x45, 0x47, 0x52, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x17, 0x0a,
	0x13, 0x4c, 0x4f, 0x47, 0x49, 0x53, 0x54, 0x49, 0x43, 0x5f, 0x52, 0x45, 0x47, 0x52, 0x45, 0x53,
	0x53, 0x49, 0x4f, 0x4e, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x4b, 0x4d, 0x45, 0x41, 0x4e, 0x53,
	0x10, 0x03, 0x12, 0x18, 0x0a, 0x14, 0x4d, 0x41, 0x54, 0x52, 0x49, 0x58, 0x5f, 0x46, 0x41, 0x43,
	0x54, 0x4f, 0x52, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x04, 0x12, 0x12, 0x0a, 0x0e,
	0x44, 0x4e, 0x4e, 0x5f, 0x43, 0x4c, 0x41, 0x53, 0x53, 0x49, 0x46, 0x49, 0x45, 0x52, 0x10, 0x05,
	0x12, 0x0e, 0x0a, 0x0a, 0x54, 0x45, 0x4e, 0x53, 0x4f, 0x52, 0x46, 0x4c, 0x4f, 0x57, 0x10, 0x06,
	0x12, 0x11, 0x0a, 0x0d, 0x44, 0x4e, 0x4e, 0x5f, 0x52, 0x45, 0x47, 0x52, 0x45, 0x53, 0x53, 0x4f,
	0x52, 0x10, 0x07, 0x12, 0x1a, 0x0a, 0x16, 0x42, 0x4f, 0x4f, 0x53, 0x54, 0x45, 0x44, 0x5f, 0x54,
	0x52, 0x45, 0x45, 0x5f, 0x52, 0x45, 0x47, 0x52, 0x45, 0x53, 0x53, 0x4f, 0x52, 0x10, 0x09, 0x12,
	0x1b, 0x0a, 0x17, 0x42, 0x4f, 0x4f, 0x53, 0x54, 0x45, 0x44, 0x5f, 0x54, 0x52, 0x45, 0x45, 0x5f,
	0x43, 0x4c, 0x41, 0x53, 0x53, 0x49, 0x46, 0x49, 0x45, 0x52, 0x10, 0x0a, 0x12, 0x09, 0x0a, 0x05,
	0x41, 0x52, 0x49, 0x4d, 0x41, 0x10, 0x0b, 0x12, 0x14, 0x0a, 0x10, 0x41, 0x55, 0x54, 0x4f, 0x4d,
	0x4c, 0x5f, 0x52, 0x45, 0x47, 0x52, 0x45, 0x53, 0x53, 0x4f, 0x52, 0x10, 0x0c, 0x12, 0x15, 0x0a,
	0x11, 0x41, 0x55, 0x54, 0x4f, 0x4d, 0x4c, 0x5f, 0x43, 0x4c, 0x41, 0x53, 0x53, 0x49, 0x46, 0x49,
	0x45, 0x52, 0x10, 0x0d, 0x22, 0x4f, 0x0a, 0x08, 0x4c, 0x6f, 0x73, 0x73, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x19, 0x0a, 0x15, 0x4c, 0x4f, 0x53, 0x53, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x4d,
	0x45, 0x41, 0x4e, 0x5f, 0x53, 0x51, 0x55, 0x41, 0x52, 0x45, 0x44, 0x5f, 0x4c, 0x4f, 0x53, 0x53,
	0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d, 0x4d, 0x45, 0x41, 0x4e, 0x5f, 0x4c, 0x4f, 0x47, 0x5f, 0x4c,
	0x4f, 0x53, 0x53, 0x10, 0x02, 0x22, 0x48, 0x0a, 0x0c, 0x44, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x44, 0x49, 0x53, 0x54, 0x41, 0x4e, 0x43,
	0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x45, 0x55, 0x43, 0x4c, 0x49, 0x44, 0x45, 0x41,
	0x4e, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x4f, 0x53, 0x49, 0x4e, 0x45, 0x10, 0x02, 0x22,
	0x7a, 0x0a, 0x0f, 0x44, 0x61, 0x74, 0x61, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x68,
	0x6f, 0x64, 0x12, 0x21, 0x0a, 0x1d, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x53, 0x50, 0x4c, 0x49, 0x54,
	0x5f, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x52, 0x41, 0x4e, 0x44, 0x4f, 0x4d, 0x10,
	0x01, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x10, 0x02, 0x12, 0x0e, 0x0a,
	0x0a, 0x53, 0x45, 0x51, 0x55, 0x45, 0x4e, 0x54, 0x49, 0x41, 0x4c, 0x10, 0x03, 0x12, 0x0c, 0x0a,
	0x08, 0x4e, 0x4f, 0x5f, 0x53, 0x50, 0x4c, 0x49, 0x54, 0x10, 0x04, 0x12, 0x0e, 0x0a, 0x0a, 0x41,
	0x55, 0x54, 0x4f, 0x5f, 0x53, 0x50, 0x4c, 0x49, 0x54, 0x10, 0x05, 0x22, 0x8e, 0x01, 0x0a, 0x0d,
	0x44, 0x61, 0x74, 0x61, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x1e, 0x0a,
	0x1a, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x46, 0x52, 0x45, 0x51, 0x55, 0x45, 0x4e, 0x43, 0x59, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a,
	0x0e, 0x41, 0x55, 0x54, 0x4f, 0x5f, 0x46, 0x52, 0x45, 0x51, 0x55, 0x45, 0x4e, 0x43, 0x59, 0x10,
	0x01, 0x12, 0x0a, 0x0a, 0x06, 0x59, 0x45, 0x41, 0x52, 0x4c, 0x59, 0x10, 0x02, 0x12, 0x0d, 0x0a,
	0x09, 0x51, 0x55, 0x41, 0x52, 0x54, 0x45, 0x52, 0x4c, 0x59, 0x10, 0x03, 0x12, 0x0b, 0x0a, 0x07,
	0x4d, 0x4f, 0x4e, 0x54, 0x48, 0x4c, 0x59, 0x10, 0x04, 0x12, 0x0a, 0x0a, 0x06, 0x57, 0x45, 0x45,
	0x4b, 0x4c, 0x59, 0x10, 0x05, 0x12, 0x09, 0x0a, 0x05, 0x44, 0x41, 0x49, 0x4c, 0x59, 0x10, 0x06,
	0x12, 0x0a, 0x0a, 0x06, 0x48, 0x4f, 0x55, 0x52, 0x4c, 0x59, 0x10, 0x07, 0x22, 0xd9, 0x04, 0x0a,
	0x0d, 0x48, 0x6f, 0x6c, 0x69, 0x64, 0x61, 0x79, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x12, 0x1e,
	0x0a, 0x1a, 0x48, 0x4f, 0x4c, 0x49, 0x44, 0x41, 0x59, 0x5f, 0x52, 0x45, 0x47, 0x49, 0x4f, 0x4e,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a,
	0x0a, 0x06, 0x47, 0x4c, 0x4f, 0x42, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x06, 0x0a, 0x02, 0x4e, 0x41,
	0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x4a, 0x41, 0x50, 0x41, 0x43, 0x10, 0x03, 0x12, 0x08, 0x0a,
	0x04, 0x45, 0x4d, 0x45, 0x41, 0x10, 0x04, 0x12, 0x07, 0x0a, 0x03, 0x4c, 0x41, 0x43, 0x10, 0x05,
	0x12, 0x06, 0x0a, 0x02, 0x41, 0x45, 0x10, 0x06, 0x12, 0x06, 0x0a, 0x02, 0x41, 0x52, 0x10, 0x07,
	0x12, 0x06, 0x0a, 0x02, 0x41, 0x54, 0x10, 0x08, 0x12, 0x06, 0x0a, 0x02, 0x41, 0x55, 0x10, 0x09,
	0x12, 0x06, 0x0a, 0x02, 0x42, 0x45, 0x10, 0x0a, 0x12, 0x06, 0x0a, 0x02, 0x42, 0x52, 0x10, 0x0b,
	0x12, 0x06, 0x0a, 0x02, 0x43, 0x41, 0x10, 0x0c, 0x12, 0x06, 0x0a, 0x02, 0x43, 0x48, 0x10, 0x0d,
	0x12, 0x06, 0x0a, 0x02, 0x43, 0x4c, 0x10, 0x0e, 0x12, 0x06, 0x0a, 0x02, 0x43, 0x4e, 0x10, 0x0f,
	0x12, 0x06, 0x0a, 0x02, 0x43, 0x4f, 0x10, 0x10, 0x12, 0x06, 0x0a, 0x02, 0x43, 0x53, 0x10, 0x11,
	0x12, 0x06, 0x0a, 0x02, 0x43, 0x5a, 0x10, 0x12, 0x12, 0x06, 0x0a, 0x02, 0x44, 0x45, 0x10, 0x13,
	0x12, 0x06, 0x0a, 0x02, 0x44, 0x4b, 0x10, 0x14, 0x12, 0x06, 0x0a, 0x02, 0x44, 0x5a, 0x10, 0x15,
	0x12, 0x06, 0x0a, 0x02, 0x45, 0x43, 0x10, 0x16, 0x12, 0x06, 0x0a, 0x02, 0x45, 0x45, 0x10, 0x17,
	0x12, 0x06, 0x0a, 0x02, 0x45, 0x47, 0x10, 0x18, 0x12, 0x06, 0x0a, 0x02, 0x45, 0x53, 0x10, 0x19,
	0x12, 0x06, 0x0a, 0x02, 0x46, 0x49, 0x10, 0x1a, 0x12, 0x06, 0x0a, 0x02, 0x46, 0x52, 0x10, 0x1b,
	0x12, 0x06, 0x0a, 0x02, 0x47, 0x42, 0x10, 0x1c, 0x12, 0x06, 0x0a, 0x02, 0x47, 0x52, 0x10, 0x1d,
	0x12, 0x06, 0x0a, 0x02, 0x48, 0x4b, 0x10, 0x1e, 0x12, 0x06, 0x0a, 0x02, 0x48, 0x55, 0x10, 0x1f,
	0x12, 0x06, 0x0a, 0x02, 0x49, 0x44, 0x10, 0x20, 0x12, 0x06, 0x0a, 0x02, 0x49, 0x45, 0x10, 0x21,
	0x12, 0x06, 0x0a, 0x02, 0x49, 0x4c, 0x10, 0x22, 0x12, 0x06, 0x0a, 0x02, 0x49, 0x4e, 0x10, 0x23,
	0x12, 0x06, 0x0a, 0x02, 0x49, 0x52, 0x10, 0x24, 0x12, 0x06, 0x0a, 0x02, 0x49, 0x54, 0x10, 0x25,
	0x12, 0x06, 0x0a, 0x02, 0x4a, 0x50, 0x10, 0x26, 0x12, 0x06, 0x0a, 0x02, 0x4b, 0x52, 0x10, 0x27,
	0x12, 0x06, 0x0a, 0x02, 0x4c, 0x56, 0x10, 0x28, 0x12, 0x06, 0x0a, 0x02, 0x4d, 0x41, 0x10, 0x29,
	0x12, 0x06, 0x0a, 0x02, 0x4d, 0x58, 0x10, 0x2a, 0x12, 0x06, 0x0a, 0x02, 0x4d, 0x59, 0x10, 0x2b,
	0x12, 0x06, 0x0a, 0x02, 0x4e, 0x47, 0x10, 0x2c, 0x12, 0x06, 0x0a, 0x02, 0x4e, 0x4c, 0x10, 0x2d,
	0x12, 0x06, 0x0a, 0x02, 0x4e, 0x4f, 0x10, 0x2e, 0x12, 0x06, 0x0a, 0x02, 0x4e, 0x5a, 0x10, 0x2f,
	0x12, 0x06, 0x0a, 0x02, 0x50, 0x45, 0x10, 0x30, 0x12, 0x06, 0x0a, 0x02, 0x50, 0x48, 0x10, 0x31,
	0x12, 0x06, 0x0a, 0x02, 0x50, 0x4b, 0x10, 0x32, 0x12, 0x06, 0x0a, 0x02, 0x50, 0x4c, 0x10, 0x33,
	0x12, 0x06, 0x0a, 0x02, 0x50, 0x54, 0x10, 0x34, 0x12, 0x06, 0x0a, 0x02, 0x52, 0x4f, 0x10, 0x35,
	0x12, 0x06, 0x0a, 0x02, 0x52, 0x53, 0x10, 0x36, 0x12, 0x06, 0x0a, 0x02, 0x52, 0x55, 0x10, 0x37,
	0x12, 0x06, 0x0a, 0x02, 0x53, 0x41, 0x10, 0x38, 0x12, 0x06, 0x0a, 0x02, 0x53, 0x45, 0x10, 0x39,
	0x12, 0x06, 0x0a, 0x02, 0x53, 0x47, 0x10, 0x3a, 0x12, 0x06, 0x0a, 0x02, 0x53, 0x49, 0x10, 0x3b,
	0x12, 0x06, 0x0a, 0x02, 0x53, 0x4b, 0x10, 0x3c, 0x12, 0x06, 0x0a, 0x02, 0x54, 0x48, 0x10, 0x3d,
	0x12, 0x06, 0x0a, 0x02, 0x54, 0x52, 0x10, 0x3e, 0x12, 0x06, 0x0a, 0x02, 0x54, 0x57, 0x10, 0x3f,
	0x12, 0x06, 0x0a, 0x02, 0x55, 0x41, 0x10, 0x40, 0x12, 0x06, 0x0a, 0x02, 0x55, 0x53, 0x10, 0x41,
	0x12, 0x06, 0x0a, 0x02, 0x56, 0x45, 0x10, 0x42, 0x12, 0x06, 0x0a, 0x02, 0x56, 0x4e, 0x10, 0x43,
	0x12, 0x06, 0x0a, 0x02, 0x5a, 0x41, 0x10, 0x44, 0x22, 0x57, 0x0a, 0x11, 0x4c, 0x65, 0x61, 0x72,
	0x6e, 0x52, 0x61, 0x74, 0x65, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x12, 0x23, 0x0a,
	0x1f, 0x4c, 0x45, 0x41, 0x52, 0x4e, 0x5f, 0x52, 0x41, 0x54, 0x45, 0x5f, 0x53, 0x54, 0x52, 0x41,
	0x54, 0x45, 0x47, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x4c, 0x49, 0x4e, 0x45, 0x5f, 0x53, 0x45, 0x41, 0x52, 0x43,
	0x48, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x4f, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x54, 0x10,
	0x02, 0x22, 0x6e, 0x0a, 0x14, 0x4f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x12, 0x25, 0x0a, 0x21, 0x4f, 0x50, 0x54,
	0x49, 0x4d, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x54, 0x52, 0x41, 0x54, 0x45,
	0x47, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x1a, 0x0a, 0x16, 0x42, 0x41, 0x54, 0x43, 0x48, 0x5f, 0x47, 0x52, 0x41, 0x44, 0x49, 0x45,
	0x4e, 0x54, 0x5f, 0x44, 0x45, 0x53, 0x43, 0x45, 0x4e, 0x54, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f,
	0x4e, 0x4f, 0x52, 0x4d, 0x41, 0x4c, 0x5f, 0x45, 0x51, 0x55, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10,
	0x02, 0x22, 0x49, 0x0a, 0x0c, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x1d, 0x0a, 0x19, 0x46, 0x45, 0x45, 0x44, 0x42, 0x41, 0x43, 0x4b, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0c, 0x0a, 0x08, 0x49, 0x4d, 0x50, 0x4c, 0x49, 0x43, 0x49, 0x54, 0x10, 0x01, 0x12, 0x0c,
	0x0a, 0x08, 0x45, 0x58, 0x50, 0x4c, 0x49, 0x43, 0x49, 0x54, 0x10, 0x02, 0x22, 0x79, 0x0a, 0x0f,
	0x47, 0x65, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x22, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x49, 0x64, 0x12, 0x22, 0x0a, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x49, 0x64, 0x12, 0x1e, 0x0a, 0x08, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x49, 0x64, 0x22, 0xb7, 0x01, 0x0a, 0x11, 0x50, 0x61, 0x74, 0x63,
	0x68, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x22, 0x0a,
	0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49,
	0x64, 0x12, 0x22, 0x0a, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61,
	0x73, 0x65, 0x74, 0x49, 0x64, 0x12, 0x1e, 0x0a, 0x08, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x69,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x49, 0x64, 0x12, 0x3a, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x22, 0x7c, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x22, 0x0a, 0x0a, 0x64,
	0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x49, 0x64, 0x12,
	0x1e, 0x0a, 0x08, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x49, 0x64, 0x22,
	0xb9, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x22, 0x0a, 0x0a, 0x64, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x49, 0x64, 0x12, 0x3d, 0x0a,
	0x0b, 0x6d, 0x61, 0x78, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x0a, 0x6d, 0x61, 0x78, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x75, 0x0a, 0x12, 0x4c,
	0x69, 0x73, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x37, 0x0a, 0x06, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x52, 0x06, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x32, 0xfa, 0x05, 0x0a, 0x0c, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x12, 0x79, 0x0a, 0x08, 0x47, 0x65, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12,
	0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x74, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x22, 0x21, 0xda, 0x41, 0x1e,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x12, 0x8d,
	0x01, 0x0a, 0x0a, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x12, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x24, 0xda, 0x41, 0x21, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f,
	0x69, 0x64, 0x2c, 0x6d, 0x61, 0x78, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x83,
	0x01, 0x0a, 0x0a, 0x50, 0x61, 0x74, 0x63, 0x68, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x61, 0x74, 0x63, 0x68, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x22, 0x27, 0xda, 0x41, 0x24,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x2c, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x12, 0x76, 0x0a, 0x0b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x21, 0xda, 0x41, 0x1e, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x5f, 0x69, 0x64, 0x2c, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x1a, 0xe0, 0x01, 0xca,
	0x41, 0x17, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0xc2, 0x01, 0x68, 0x74, 0x74,
	0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72,
	0x65, 0x61, 0x64, 0x6f, 0x6e, 0x6c, 0x79, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f,
	0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77,
	0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x72, 0x65, 0x61, 0x64, 0x2d, 0x6f, 0x6e, 0x6c, 0x79, 0x42,
	0x6c, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x42,
	0x0a, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x5a, 0x40, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67,
	0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2f, 0x76, 0x32, 0x3b, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_bigquery_v2_model_proto_rawDescOnce sync.Once
	file_google_cloud_bigquery_v2_model_proto_rawDescData = file_google_cloud_bigquery_v2_model_proto_rawDesc
)

func file_google_cloud_bigquery_v2_model_proto_rawDescGZIP() []byte {
	file_google_cloud_bigquery_v2_model_proto_rawDescOnce.Do(func() {
		file_google_cloud_bigquery_v2_model_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_bigquery_v2_model_proto_rawDescData)
	})
	return file_google_cloud_bigquery_v2_model_proto_rawDescData
}

var file_google_cloud_bigquery_v2_model_proto_enumTypes = make([]protoimpl.EnumInfo, 11)
var file_google_cloud_bigquery_v2_model_proto_msgTypes = make([]protoimpl.MessageInfo, 39)
var file_google_cloud_bigquery_v2_model_proto_goTypes = []interface{}{
	(Model_ModelType)(0),                                                  // 0: google.cloud.bigquery.v2.Model.ModelType
	(Model_LossType)(0),                                                   // 1: google.cloud.bigquery.v2.Model.LossType
	(Model_DistanceType)(0),                                               // 2: google.cloud.bigquery.v2.Model.DistanceType
	(Model_DataSplitMethod)(0),                                            // 3: google.cloud.bigquery.v2.Model.DataSplitMethod
	(Model_DataFrequency)(0),                                              // 4: google.cloud.bigquery.v2.Model.DataFrequency
	(Model_HolidayRegion)(0),                                              // 5: google.cloud.bigquery.v2.Model.HolidayRegion
	(Model_LearnRateStrategy)(0),                                          // 6: google.cloud.bigquery.v2.Model.LearnRateStrategy
	(Model_OptimizationStrategy)(0),                                       // 7: google.cloud.bigquery.v2.Model.OptimizationStrategy
	(Model_FeedbackType)(0),                                               // 8: google.cloud.bigquery.v2.Model.FeedbackType
	(Model_SeasonalPeriod_SeasonalPeriodType)(0),                          // 9: google.cloud.bigquery.v2.Model.SeasonalPeriod.SeasonalPeriodType
	(Model_KmeansEnums_KmeansInitializationMethod)(0),                     // 10: google.cloud.bigquery.v2.Model.KmeansEnums.KmeansInitializationMethod
	(*Model)(nil),                                                         // 11: google.cloud.bigquery.v2.Model
	(*GetModelRequest)(nil),                                               // 12: google.cloud.bigquery.v2.GetModelRequest
	(*PatchModelRequest)(nil),                                             // 13: google.cloud.bigquery.v2.PatchModelRequest
	(*DeleteModelRequest)(nil),                                            // 14: google.cloud.bigquery.v2.DeleteModelRequest
	(*ListModelsRequest)(nil),                                             // 15: google.cloud.bigquery.v2.ListModelsRequest
	(*ListModelsResponse)(nil),                                            // 16: google.cloud.bigquery.v2.ListModelsResponse
	(*Model_SeasonalPeriod)(nil),                                          // 17: google.cloud.bigquery.v2.Model.SeasonalPeriod
	(*Model_KmeansEnums)(nil),                                             // 18: google.cloud.bigquery.v2.Model.KmeansEnums
	(*Model_RegressionMetrics)(nil),                                       // 19: google.cloud.bigquery.v2.Model.RegressionMetrics
	(*Model_AggregateClassificationMetrics)(nil),                          // 20: google.cloud.bigquery.v2.Model.AggregateClassificationMetrics
	(*Model_BinaryClassificationMetrics)(nil),                             // 21: google.cloud.bigquery.v2.Model.BinaryClassificationMetrics
	(*Model_MultiClassClassificationMetrics)(nil),                         // 22: google.cloud.bigquery.v2.Model.MultiClassClassificationMetrics
	(*Model_ClusteringMetrics)(nil),                                       // 23: google.cloud.bigquery.v2.Model.ClusteringMetrics
	(*Model_RankingMetrics)(nil),                                          // 24: google.cloud.bigquery.v2.Model.RankingMetrics
	(*Model_ArimaForecastingMetrics)(nil),                                 // 25: google.cloud.bigquery.v2.Model.ArimaForecastingMetrics
	(*Model_EvaluationMetrics)(nil),                                       // 26: google.cloud.bigquery.v2.Model.EvaluationMetrics
	(*Model_DataSplitResult)(nil),                                         // 27: google.cloud.bigquery.v2.Model.DataSplitResult
	(*Model_ArimaOrder)(nil),                                              // 28: google.cloud.bigquery.v2.Model.ArimaOrder
	(*Model_ArimaFittingMetrics)(nil),                                     // 29: google.cloud.bigquery.v2.Model.ArimaFittingMetrics
	(*Model_GlobalExplanation)(nil),                                       // 30: google.cloud.bigquery.v2.Model.GlobalExplanation
	(*Model_TrainingRun)(nil),                                             // 31: google.cloud.bigquery.v2.Model.TrainingRun
	nil,                                                                   // 32: google.cloud.bigquery.v2.Model.LabelsEntry
	(*Model_BinaryClassificationMetrics_BinaryConfusionMatrix)(nil),       // 33: google.cloud.bigquery.v2.Model.BinaryClassificationMetrics.BinaryConfusionMatrix
	(*Model_MultiClassClassificationMetrics_ConfusionMatrix)(nil),         // 34: google.cloud.bigquery.v2.Model.MultiClassClassificationMetrics.ConfusionMatrix
	(*Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry)(nil),   // 35: google.cloud.bigquery.v2.Model.MultiClassClassificationMetrics.ConfusionMatrix.Entry
	(*Model_MultiClassClassificationMetrics_ConfusionMatrix_Row)(nil),     // 36: google.cloud.bigquery.v2.Model.MultiClassClassificationMetrics.ConfusionMatrix.Row
	(*Model_ClusteringMetrics_Cluster)(nil),                               // 37: google.cloud.bigquery.v2.Model.ClusteringMetrics.Cluster
	(*Model_ClusteringMetrics_Cluster_FeatureValue)(nil),                  // 38: google.cloud.bigquery.v2.Model.ClusteringMetrics.Cluster.FeatureValue
	(*Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue)(nil), // 39: google.cloud.bigquery.v2.Model.ClusteringMetrics.Cluster.FeatureValue.CategoricalValue
	(*Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue_CategoryCount)(nil), // 40: google.cloud.bigquery.v2.Model.ClusteringMetrics.Cluster.FeatureValue.CategoricalValue.CategoryCount
	(*Model_ArimaForecastingMetrics_ArimaSingleModelForecastingMetrics)(nil),            // 41: google.cloud.bigquery.v2.Model.ArimaForecastingMetrics.ArimaSingleModelForecastingMetrics
	(*Model_GlobalExplanation_Explanation)(nil),                                         // 42: google.cloud.bigquery.v2.Model.GlobalExplanation.Explanation
	(*Model_TrainingRun_TrainingOptions)(nil),                                           // 43: google.cloud.bigquery.v2.Model.TrainingRun.TrainingOptions
	(*Model_TrainingRun_IterationResult)(nil),                                           // 44: google.cloud.bigquery.v2.Model.TrainingRun.IterationResult
	nil, // 45: google.cloud.bigquery.v2.Model.TrainingRun.TrainingOptions.LabelClassWeightsEntry
	(*Model_TrainingRun_IterationResult_ClusterInfo)(nil),                   // 46: google.cloud.bigquery.v2.Model.TrainingRun.IterationResult.ClusterInfo
	(*Model_TrainingRun_IterationResult_ArimaResult)(nil),                   // 47: google.cloud.bigquery.v2.Model.TrainingRun.IterationResult.ArimaResult
	(*Model_TrainingRun_IterationResult_ArimaResult_ArimaCoefficients)(nil), // 48: google.cloud.bigquery.v2.Model.TrainingRun.IterationResult.ArimaResult.ArimaCoefficients
	(*Model_TrainingRun_IterationResult_ArimaResult_ArimaModelInfo)(nil),    // 49: google.cloud.bigquery.v2.Model.TrainingRun.IterationResult.ArimaResult.ArimaModelInfo
	(*ModelReference)(nil),          // 50: google.cloud.bigquery.v2.ModelReference
	(*EncryptionConfiguration)(nil), // 51: google.cloud.bigquery.v2.EncryptionConfiguration
	(*StandardSqlField)(nil),        // 52: google.cloud.bigquery.v2.StandardSqlField
	(*wrapperspb.UInt32Value)(nil),  // 53: google.protobuf.UInt32Value
	(*wrapperspb.DoubleValue)(nil),  // 54: google.protobuf.DoubleValue
	(*TableReference)(nil),          // 55: google.cloud.bigquery.v2.TableReference
	(*timestamppb.Timestamp)(nil),   // 56: google.protobuf.Timestamp
	(*wrapperspb.Int64Value)(nil),   // 57: google.protobuf.Int64Value
	(*wrapperspb.BoolValue)(nil),    // 58: google.protobuf.BoolValue
	(*wrapperspb.Int32Value)(nil),   // 59: google.protobuf.Int32Value
	(*emptypb.Empty)(nil),           // 60: google.protobuf.Empty
}
var file_google_cloud_bigquery_v2_model_proto_depIdxs = []int32{
	50,  // 0: google.cloud.bigquery.v2.Model.model_reference:type_name -> google.cloud.bigquery.v2.ModelReference
	32,  // 1: google.cloud.bigquery.v2.Model.labels:type_name -> google.cloud.bigquery.v2.Model.LabelsEntry
	51,  // 2: google.cloud.bigquery.v2.Model.encryption_configuration:type_name -> google.cloud.bigquery.v2.EncryptionConfiguration
	0,   // 3: google.cloud.bigquery.v2.Model.model_type:type_name -> google.cloud.bigquery.v2.Model.ModelType
	31,  // 4: google.cloud.bigquery.v2.Model.training_runs:type_name -> google.cloud.bigquery.v2.Model.TrainingRun
	52,  // 5: google.cloud.bigquery.v2.Model.feature_columns:type_name -> google.cloud.bigquery.v2.StandardSqlField
	52,  // 6: google.cloud.bigquery.v2.Model.label_columns:type_name -> google.cloud.bigquery.v2.StandardSqlField
	11,  // 7: google.cloud.bigquery.v2.PatchModelRequest.model:type_name -> google.cloud.bigquery.v2.Model
	53,  // 8: google.cloud.bigquery.v2.ListModelsRequest.max_results:type_name -> google.protobuf.UInt32Value
	11,  // 9: google.cloud.bigquery.v2.ListModelsResponse.models:type_name -> google.cloud.bigquery.v2.Model
	54,  // 10: google.cloud.bigquery.v2.Model.RegressionMetrics.mean_absolute_error:type_name -> google.protobuf.DoubleValue
	54,  // 11: google.cloud.bigquery.v2.Model.RegressionMetrics.mean_squared_error:type_name -> google.protobuf.DoubleValue
	54,  // 12: google.cloud.bigquery.v2.Model.RegressionMetrics.mean_squared_log_error:type_name -> google.protobuf.DoubleValue
	54,  // 13: google.cloud.bigquery.v2.Model.RegressionMetrics.median_absolute_error:type_name -> google.protobuf.DoubleValue
	54,  // 14: google.cloud.bigquery.v2.Model.RegressionMetrics.r_squared:type_name -> google.protobuf.DoubleValue
	54,  // 15: google.cloud.bigquery.v2.Model.AggregateClassificationMetrics.precision:type_name -> google.protobuf.DoubleValue
	54,  // 16: google.cloud.bigquery.v2.Model.AggregateClassificationMetrics.recall:type_name -> google.protobuf.DoubleValue
	54,  // 17: google.cloud.bigquery.v2.Model.AggregateClassificationMetrics.accuracy:type_name -> google.protobuf.DoubleValue
	54,  // 18: google.cloud.bigquery.v2.Model.AggregateClassificationMetrics.threshold:type_name -> google.protobuf.DoubleValue
	54,  // 19: google.cloud.bigquery.v2.Model.AggregateClassificationMetrics.f1_score:type_name -> google.protobuf.DoubleValue
	54,  // 20: google.cloud.bigquery.v2.Model.AggregateClassificationMetrics.log_loss:type_name -> google.protobuf.DoubleValue
	54,  // 21: google.cloud.bigquery.v2.Model.AggregateClassificationMetrics.roc_auc:type_name -> google.protobuf.DoubleValue
	20,  // 22: google.cloud.bigquery.v2.Model.BinaryClassificationMetrics.aggregate_classification_metrics:type_name -> google.cloud.bigquery.v2.Model.AggregateClassificationMetrics
	33,  // 23: google.cloud.bigquery.v2.Model.BinaryClassificationMetrics.binary_confusion_matrix_list:type_name -> google.cloud.bigquery.v2.Model.BinaryClassificationMetrics.BinaryConfusionMatrix
	20,  // 24: google.cloud.bigquery.v2.Model.MultiClassClassificationMetrics.aggregate_classification_metrics:type_name -> google.cloud.bigquery.v2.Model.AggregateClassificationMetrics
	34,  // 25: google.cloud.bigquery.v2.Model.MultiClassClassificationMetrics.confusion_matrix_list:type_name -> google.cloud.bigquery.v2.Model.MultiClassClassificationMetrics.ConfusionMatrix
	54,  // 26: google.cloud.bigquery.v2.Model.ClusteringMetrics.davies_bouldin_index:type_name -> google.protobuf.DoubleValue
	54,  // 27: google.cloud.bigquery.v2.Model.ClusteringMetrics.mean_squared_distance:type_name -> google.protobuf.DoubleValue
	37,  // 28: google.cloud.bigquery.v2.Model.ClusteringMetrics.clusters:type_name -> google.cloud.bigquery.v2.Model.ClusteringMetrics.Cluster
	54,  // 29: google.cloud.bigquery.v2.Model.RankingMetrics.mean_average_precision:type_name -> google.protobuf.DoubleValue
	54,  // 30: google.cloud.bigquery.v2.Model.RankingMetrics.mean_squared_error:type_name -> google.protobuf.DoubleValue
	54,  // 31: google.cloud.bigquery.v2.Model.RankingMetrics.normalized_discounted_cumulative_gain:type_name -> google.protobuf.DoubleValue
	54,  // 32: google.cloud.bigquery.v2.Model.RankingMetrics.average_rank:type_name -> google.protobuf.DoubleValue
	28,  // 33: google.cloud.bigquery.v2.Model.ArimaForecastingMetrics.non_seasonal_order:type_name -> google.cloud.bigquery.v2.Model.ArimaOrder
	29,  // 34: google.cloud.bigquery.v2.Model.ArimaForecastingMetrics.arima_fitting_metrics:type_name -> google.cloud.bigquery.v2.Model.ArimaFittingMetrics
	9,   // 35: google.cloud.bigquery.v2.Model.ArimaForecastingMetrics.seasonal_periods:type_name -> google.cloud.bigquery.v2.Model.SeasonalPeriod.SeasonalPeriodType
	41,  // 36: google.cloud.bigquery.v2.Model.ArimaForecastingMetrics.arima_single_model_forecasting_metrics:type_name -> google.cloud.bigquery.v2.Model.ArimaForecastingMetrics.ArimaSingleModelForecastingMetrics
	19,  // 37: google.cloud.bigquery.v2.Model.EvaluationMetrics.regression_metrics:type_name -> google.cloud.bigquery.v2.Model.RegressionMetrics
	21,  // 38: google.cloud.bigquery.v2.Model.EvaluationMetrics.binary_classification_metrics:type_name -> google.cloud.bigquery.v2.Model.BinaryClassificationMetrics
	22,  // 39: google.cloud.bigquery.v2.Model.EvaluationMetrics.multi_class_classification_metrics:type_name -> google.cloud.bigquery.v2.Model.MultiClassClassificationMetrics
	23,  // 40: google.cloud.bigquery.v2.Model.EvaluationMetrics.clustering_metrics:type_name -> google.cloud.bigquery.v2.Model.ClusteringMetrics
	24,  // 41: google.cloud.bigquery.v2.Model.EvaluationMetrics.ranking_metrics:type_name -> google.cloud.bigquery.v2.Model.RankingMetrics
	25,  // 42: google.cloud.bigquery.v2.Model.EvaluationMetrics.arima_forecasting_metrics:type_name -> google.cloud.bigquery.v2.Model.ArimaForecastingMetrics
	55,  // 43: google.cloud.bigquery.v2.Model.DataSplitResult.training_table:type_name -> google.cloud.bigquery.v2.TableReference
	55,  // 44: google.cloud.bigquery.v2.Model.DataSplitResult.evaluation_table:type_name -> google.cloud.bigquery.v2.TableReference
	42,  // 45: google.cloud.bigquery.v2.Model.GlobalExplanation.explanations:type_name -> google.cloud.bigquery.v2.Model.GlobalExplanation.Explanation
	43,  // 46: google.cloud.bigquery.v2.Model.TrainingRun.training_options:type_name -> google.cloud.bigquery.v2.Model.TrainingRun.TrainingOptions
	56,  // 47: google.cloud.bigquery.v2.Model.TrainingRun.start_time:type_name -> google.protobuf.Timestamp
	44,  // 48: google.cloud.bigquery.v2.Model.TrainingRun.results:type_name -> google.cloud.bigquery.v2.Model.TrainingRun.IterationResult
	26,  // 49: google.cloud.bigquery.v2.Model.TrainingRun.evaluation_metrics:type_name -> google.cloud.bigquery.v2.Model.EvaluationMetrics
	27,  // 50: google.cloud.bigquery.v2.Model.TrainingRun.data_split_result:type_name -> google.cloud.bigquery.v2.Model.DataSplitResult
	30,  // 51: google.cloud.bigquery.v2.Model.TrainingRun.global_explanations:type_name -> google.cloud.bigquery.v2.Model.GlobalExplanation
	54,  // 52: google.cloud.bigquery.v2.Model.BinaryClassificationMetrics.BinaryConfusionMatrix.positive_class_threshold:type_name -> google.protobuf.DoubleValue
	57,  // 53: google.cloud.bigquery.v2.Model.BinaryClassificationMetrics.BinaryConfusionMatrix.true_positives:type_name -> google.protobuf.Int64Value
	57,  // 54: google.cloud.bigquery.v2.Model.BinaryClassificationMetrics.BinaryConfusionMatrix.false_positives:type_name -> google.protobuf.Int64Value
	57,  // 55: google.cloud.bigquery.v2.Model.BinaryClassificationMetrics.BinaryConfusionMatrix.true_negatives:type_name -> google.protobuf.Int64Value
	57,  // 56: google.cloud.bigquery.v2.Model.BinaryClassificationMetrics.BinaryConfusionMatrix.false_negatives:type_name -> google.protobuf.Int64Value
	54,  // 57: google.cloud.bigquery.v2.Model.BinaryClassificationMetrics.BinaryConfusionMatrix.precision:type_name -> google.protobuf.DoubleValue
	54,  // 58: google.cloud.bigquery.v2.Model.BinaryClassificationMetrics.BinaryConfusionMatrix.recall:type_name -> google.protobuf.DoubleValue
	54,  // 59: google.cloud.bigquery.v2.Model.BinaryClassificationMetrics.BinaryConfusionMatrix.f1_score:type_name -> google.protobuf.DoubleValue
	54,  // 60: google.cloud.bigquery.v2.Model.BinaryClassificationMetrics.BinaryConfusionMatrix.accuracy:type_name -> google.protobuf.DoubleValue
	54,  // 61: google.cloud.bigquery.v2.Model.MultiClassClassificationMetrics.ConfusionMatrix.confidence_threshold:type_name -> google.protobuf.DoubleValue
	36,  // 62: google.cloud.bigquery.v2.Model.MultiClassClassificationMetrics.ConfusionMatrix.rows:type_name -> google.cloud.bigquery.v2.Model.MultiClassClassificationMetrics.ConfusionMatrix.Row
	57,  // 63: google.cloud.bigquery.v2.Model.MultiClassClassificationMetrics.ConfusionMatrix.Entry.item_count:type_name -> google.protobuf.Int64Value
	35,  // 64: google.cloud.bigquery.v2.Model.MultiClassClassificationMetrics.ConfusionMatrix.Row.entries:type_name -> google.cloud.bigquery.v2.Model.MultiClassClassificationMetrics.ConfusionMatrix.Entry
	38,  // 65: google.cloud.bigquery.v2.Model.ClusteringMetrics.Cluster.feature_values:type_name -> google.cloud.bigquery.v2.Model.ClusteringMetrics.Cluster.FeatureValue
	57,  // 66: google.cloud.bigquery.v2.Model.ClusteringMetrics.Cluster.count:type_name -> google.protobuf.Int64Value
	54,  // 67: google.cloud.bigquery.v2.Model.ClusteringMetrics.Cluster.FeatureValue.numerical_value:type_name -> google.protobuf.DoubleValue
	39,  // 68: google.cloud.bigquery.v2.Model.ClusteringMetrics.Cluster.FeatureValue.categorical_value:type_name -> google.cloud.bigquery.v2.Model.ClusteringMetrics.Cluster.FeatureValue.CategoricalValue
	40,  // 69: google.cloud.bigquery.v2.Model.ClusteringMetrics.Cluster.FeatureValue.CategoricalValue.category_counts:type_name -> google.cloud.bigquery.v2.Model.ClusteringMetrics.Cluster.FeatureValue.CategoricalValue.CategoryCount
	57,  // 70: google.cloud.bigquery.v2.Model.ClusteringMetrics.Cluster.FeatureValue.CategoricalValue.CategoryCount.count:type_name -> google.protobuf.Int64Value
	28,  // 71: google.cloud.bigquery.v2.Model.ArimaForecastingMetrics.ArimaSingleModelForecastingMetrics.non_seasonal_order:type_name -> google.cloud.bigquery.v2.Model.ArimaOrder
	29,  // 72: google.cloud.bigquery.v2.Model.ArimaForecastingMetrics.ArimaSingleModelForecastingMetrics.arima_fitting_metrics:type_name -> google.cloud.bigquery.v2.Model.ArimaFittingMetrics
	9,   // 73: google.cloud.bigquery.v2.Model.ArimaForecastingMetrics.ArimaSingleModelForecastingMetrics.seasonal_periods:type_name -> google.cloud.bigquery.v2.Model.SeasonalPeriod.SeasonalPeriodType
	54,  // 74: google.cloud.bigquery.v2.Model.GlobalExplanation.Explanation.attribution:type_name -> google.protobuf.DoubleValue
	1,   // 75: google.cloud.bigquery.v2.Model.TrainingRun.TrainingOptions.loss_type:type_name -> google.cloud.bigquery.v2.Model.LossType
	54,  // 76: google.cloud.bigquery.v2.Model.TrainingRun.TrainingOptions.l1_regularization:type_name -> google.protobuf.DoubleValue
	54,  // 77: google.cloud.bigquery.v2.Model.TrainingRun.TrainingOptions.l2_regularization:type_name -> google.protobuf.DoubleValue
	54,  // 78: google.cloud.bigquery.v2.Model.TrainingRun.TrainingOptions.min_relative_progress:type_name -> google.protobuf.DoubleValue
	58,  // 79: google.cloud.bigquery.v2.Model.TrainingRun.TrainingOptions.warm_start:type_name -> google.protobuf.BoolValue
	58,  // 80: google.cloud.bigquery.v2.Model.TrainingRun.TrainingOptions.early_stop:type_name -> google.protobuf.BoolValue
	3,   // 81: google.cloud.bigquery.v2.Model.TrainingRun.TrainingOptions.data_split_method:type_name -> google.cloud.bigquery.v2.Model.DataSplitMethod
	6,   // 82: google.cloud.bigquery.v2.Model.TrainingRun.TrainingOptions.learn_rate_strategy:type_name -> google.cloud.bigquery.v2.Model.LearnRateStrategy
	45,  // 83: google.cloud.bigquery.v2.Model.TrainingRun.TrainingOptions.label_class_weights:type_name -> google.cloud.bigquery.v2.Model.TrainingRun.TrainingOptions.LabelClassWeightsEntry
	2,   // 84: google.cloud.bigquery.v2.Model.TrainingRun.TrainingOptions.distance_type:type_name -> google.cloud.bigquery.v2.Model.DistanceType
	7,   // 85: google.cloud.bigquery.v2.Model.TrainingRun.TrainingOptions.optimization_strategy:type_name -> google.cloud.bigquery.v2.Model.OptimizationStrategy
	54,  // 86: google.cloud.bigquery.v2.Model.TrainingRun.TrainingOptions.dropout:type_name -> google.protobuf.DoubleValue
	54,  // 87: google.cloud.bigquery.v2.Model.TrainingRun.TrainingOptions.min_split_loss:type_name -> google.protobuf.DoubleValue
	8,   // 88: google.cloud.bigquery.v2.Model.TrainingRun.TrainingOptions.feedback_type:type_name -> google.cloud.bigquery.v2.Model.FeedbackType
	54,  // 89: google.cloud.bigquery.v2.Model.TrainingRun.TrainingOptions.wals_alpha:type_name -> google.protobuf.DoubleValue
	10,  // 90: google.cloud.bigquery.v2.Model.TrainingRun.TrainingOptions.kmeans_initialization_method:type_name -> google.cloud.bigquery.v2.Model.KmeansEnums.KmeansInitializationMethod
	28,  // 91: google.cloud.bigquery.v2.Model.TrainingRun.TrainingOptions.non_seasonal_order:type_name -> google.cloud.bigquery.v2.Model.ArimaOrder
	4,   // 92: google.cloud.bigquery.v2.Model.TrainingRun.TrainingOptions.data_frequency:type_name -> google.cloud.bigquery.v2.Model.DataFrequency
	5,   // 93: google.cloud.bigquery.v2.Model.TrainingRun.TrainingOptions.holiday_region:type_name -> google.cloud.bigquery.v2.Model.HolidayRegion
	59,  // 94: google.cloud.bigquery.v2.Model.TrainingRun.IterationResult.index:type_name -> google.protobuf.Int32Value
	57,  // 95: google.cloud.bigquery.v2.Model.TrainingRun.IterationResult.duration_ms:type_name -> google.protobuf.Int64Value
	54,  // 96: google.cloud.bigquery.v2.Model.TrainingRun.IterationResult.training_loss:type_name -> google.protobuf.DoubleValue
	54,  // 97: google.cloud.bigquery.v2.Model.TrainingRun.IterationResult.eval_loss:type_name -> google.protobuf.DoubleValue
	46,  // 98: google.cloud.bigquery.v2.Model.TrainingRun.IterationResult.cluster_infos:type_name -> google.cloud.bigquery.v2.Model.TrainingRun.IterationResult.ClusterInfo
	47,  // 99: google.cloud.bigquery.v2.Model.TrainingRun.IterationResult.arima_result:type_name -> google.cloud.bigquery.v2.Model.TrainingRun.IterationResult.ArimaResult
	54,  // 100: google.cloud.bigquery.v2.Model.TrainingRun.IterationResult.ClusterInfo.cluster_radius:type_name -> google.protobuf.DoubleValue
	57,  // 101: google.cloud.bigquery.v2.Model.TrainingRun.IterationResult.ClusterInfo.cluster_size:type_name -> google.protobuf.Int64Value
	49,  // 102: google.cloud.bigquery.v2.Model.TrainingRun.IterationResult.ArimaResult.arima_model_info:type_name -> google.cloud.bigquery.v2.Model.TrainingRun.IterationResult.ArimaResult.ArimaModelInfo
	9,   // 103: google.cloud.bigquery.v2.Model.TrainingRun.IterationResult.ArimaResult.seasonal_periods:type_name -> google.cloud.bigquery.v2.Model.SeasonalPeriod.SeasonalPeriodType
	28,  // 104: google.cloud.bigquery.v2.Model.TrainingRun.IterationResult.ArimaResult.ArimaModelInfo.non_seasonal_order:type_name -> google.cloud.bigquery.v2.Model.ArimaOrder
	48,  // 105: google.cloud.bigquery.v2.Model.TrainingRun.IterationResult.ArimaResult.ArimaModelInfo.arima_coefficients:type_name -> google.cloud.bigquery.v2.Model.TrainingRun.IterationResult.ArimaResult.ArimaCoefficients
	29,  // 106: google.cloud.bigquery.v2.Model.TrainingRun.IterationResult.ArimaResult.ArimaModelInfo.arima_fitting_metrics:type_name -> google.cloud.bigquery.v2.Model.ArimaFittingMetrics
	9,   // 107: google.cloud.bigquery.v2.Model.TrainingRun.IterationResult.ArimaResult.ArimaModelInfo.seasonal_periods:type_name -> google.cloud.bigquery.v2.Model.SeasonalPeriod.SeasonalPeriodType
	12,  // 108: google.cloud.bigquery.v2.ModelService.GetModel:input_type -> google.cloud.bigquery.v2.GetModelRequest
	15,  // 109: google.cloud.bigquery.v2.ModelService.ListModels:input_type -> google.cloud.bigquery.v2.ListModelsRequest
	13,  // 110: google.cloud.bigquery.v2.ModelService.PatchModel:input_type -> google.cloud.bigquery.v2.PatchModelRequest
	14,  // 111: google.cloud.bigquery.v2.ModelService.DeleteModel:input_type -> google.cloud.bigquery.v2.DeleteModelRequest
	11,  // 112: google.cloud.bigquery.v2.ModelService.GetModel:output_type -> google.cloud.bigquery.v2.Model
	16,  // 113: google.cloud.bigquery.v2.ModelService.ListModels:output_type -> google.cloud.bigquery.v2.ListModelsResponse
	11,  // 114: google.cloud.bigquery.v2.ModelService.PatchModel:output_type -> google.cloud.bigquery.v2.Model
	60,  // 115: google.cloud.bigquery.v2.ModelService.DeleteModel:output_type -> google.protobuf.Empty
	112, // [112:116] is the sub-list for method output_type
	108, // [108:112] is the sub-list for method input_type
	108, // [108:108] is the sub-list for extension type_name
	108, // [108:108] is the sub-list for extension extendee
	0,   // [0:108] is the sub-list for field type_name
}

func init() { file_google_cloud_bigquery_v2_model_proto_init() }
func file_google_cloud_bigquery_v2_model_proto_init() {
	if File_google_cloud_bigquery_v2_model_proto != nil {
		return
	}
	file_google_cloud_bigquery_v2_encryption_config_proto_init()
	file_google_cloud_bigquery_v2_model_reference_proto_init()
	file_google_cloud_bigquery_v2_standard_sql_proto_init()
	file_google_cloud_bigquery_v2_table_reference_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_bigquery_v2_model_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetModelRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PatchModelRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteModelRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListModelsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListModelsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_SeasonalPeriod); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_KmeansEnums); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_RegressionMetrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_AggregateClassificationMetrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_BinaryClassificationMetrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_MultiClassClassificationMetrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_ClusteringMetrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_RankingMetrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_ArimaForecastingMetrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_EvaluationMetrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_DataSplitResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_ArimaOrder); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_ArimaFittingMetrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_GlobalExplanation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_TrainingRun); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_BinaryClassificationMetrics_BinaryConfusionMatrix); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_MultiClassClassificationMetrics_ConfusionMatrix); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_MultiClassClassificationMetrics_ConfusionMatrix_Row); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_ClusteringMetrics_Cluster); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_ClusteringMetrics_Cluster_FeatureValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue_CategoryCount); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_ArimaForecastingMetrics_ArimaSingleModelForecastingMetrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_GlobalExplanation_Explanation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_TrainingRun_TrainingOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_TrainingRun_IterationResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_TrainingRun_IterationResult_ClusterInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_TrainingRun_IterationResult_ArimaResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_TrainingRun_IterationResult_ArimaResult_ArimaCoefficients); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_TrainingRun_IterationResult_ArimaResult_ArimaModelInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_bigquery_v2_model_proto_msgTypes[15].OneofWrappers = []interface{}{
		(*Model_EvaluationMetrics_RegressionMetrics)(nil),
		(*Model_EvaluationMetrics_BinaryClassificationMetrics)(nil),
		(*Model_EvaluationMetrics_MultiClassClassificationMetrics)(nil),
		(*Model_EvaluationMetrics_ClusteringMetrics)(nil),
		(*Model_EvaluationMetrics_RankingMetrics)(nil),
		(*Model_EvaluationMetrics_ArimaForecastingMetrics)(nil),
	}
	file_google_cloud_bigquery_v2_model_proto_msgTypes[27].OneofWrappers = []interface{}{
		(*Model_ClusteringMetrics_Cluster_FeatureValue_NumericalValue)(nil),
		(*Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_bigquery_v2_model_proto_rawDesc,
			NumEnums:      11,
			NumMessages:   39,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_bigquery_v2_model_proto_goTypes,
		DependencyIndexes: file_google_cloud_bigquery_v2_model_proto_depIdxs,
		EnumInfos:         file_google_cloud_bigquery_v2_model_proto_enumTypes,
		MessageInfos:      file_google_cloud_bigquery_v2_model_proto_msgTypes,
	}.Build()
	File_google_cloud_bigquery_v2_model_proto = out.File
	file_google_cloud_bigquery_v2_model_proto_rawDesc = nil
	file_google_cloud_bigquery_v2_model_proto_goTypes = nil
	file_google_cloud_bigquery_v2_model_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ModelServiceClient is the client API for ModelService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ModelServiceClient interface {
	// Gets the specified model resource by model ID.
	GetModel(ctx context.Context, in *GetModelRequest, opts ...grpc.CallOption) (*Model, error)
	// Lists all models in the specified dataset. Requires the READER dataset
	// role.
	ListModels(ctx context.Context, in *ListModelsRequest, opts ...grpc.CallOption) (*ListModelsResponse, error)
	// Patch specific fields in the specified model.
	PatchModel(ctx context.Context, in *PatchModelRequest, opts ...grpc.CallOption) (*Model, error)
	// Deletes the model specified by modelId from the dataset.
	DeleteModel(ctx context.Context, in *DeleteModelRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type modelServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewModelServiceClient(cc grpc.ClientConnInterface) ModelServiceClient {
	return &modelServiceClient{cc}
}

func (c *modelServiceClient) GetModel(ctx context.Context, in *GetModelRequest, opts ...grpc.CallOption) (*Model, error) {
	out := new(Model)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.v2.ModelService/GetModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) ListModels(ctx context.Context, in *ListModelsRequest, opts ...grpc.CallOption) (*ListModelsResponse, error) {
	out := new(ListModelsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.v2.ModelService/ListModels", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) PatchModel(ctx context.Context, in *PatchModelRequest, opts ...grpc.CallOption) (*Model, error) {
	out := new(Model)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.v2.ModelService/PatchModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) DeleteModel(ctx context.Context, in *DeleteModelRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.v2.ModelService/DeleteModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ModelServiceServer is the server API for ModelService service.
type ModelServiceServer interface {
	// Gets the specified model resource by model ID.
	GetModel(context.Context, *GetModelRequest) (*Model, error)
	// Lists all models in the specified dataset. Requires the READER dataset
	// role.
	ListModels(context.Context, *ListModelsRequest) (*ListModelsResponse, error)
	// Patch specific fields in the specified model.
	PatchModel(context.Context, *PatchModelRequest) (*Model, error)
	// Deletes the model specified by modelId from the dataset.
	DeleteModel(context.Context, *DeleteModelRequest) (*emptypb.Empty, error)
}

// UnimplementedModelServiceServer can be embedded to have forward compatible implementations.
type UnimplementedModelServiceServer struct {
}

func (*UnimplementedModelServiceServer) GetModel(context.Context, *GetModelRequest) (*Model, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetModel not implemented")
}
func (*UnimplementedModelServiceServer) ListModels(context.Context, *ListModelsRequest) (*ListModelsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListModels not implemented")
}
func (*UnimplementedModelServiceServer) PatchModel(context.Context, *PatchModelRequest) (*Model, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PatchModel not implemented")
}
func (*UnimplementedModelServiceServer) DeleteModel(context.Context, *DeleteModelRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteModel not implemented")
}

func RegisterModelServiceServer(s *grpc.Server, srv ModelServiceServer) {
	s.RegisterService(&_ModelService_serviceDesc, srv)
}

func _ModelService_GetModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).GetModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.v2.ModelService/GetModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).GetModel(ctx, req.(*GetModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_ListModels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListModelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).ListModels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.v2.ModelService/ListModels",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).ListModels(ctx, req.(*ListModelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_PatchModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PatchModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).PatchModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.v2.ModelService/PatchModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).PatchModel(ctx, req.(*PatchModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_DeleteModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).DeleteModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.v2.ModelService/DeleteModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).DeleteModel(ctx, req.(*DeleteModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ModelService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.bigquery.v2.ModelService",
	HandlerType: (*ModelServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetModel",
			Handler:    _ModelService_GetModel_Handler,
		},
		{
			MethodName: "ListModels",
			Handler:    _ModelService_ListModels_Handler,
		},
		{
			MethodName: "PatchModel",
			Handler:    _ModelService_PatchModel_Handler,
		},
		{
			MethodName: "DeleteModel",
			Handler:    _ModelService_DeleteModel_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/bigquery/v2/model.proto",
}
