<?php
/**
 * Implements the InvalidPassword class for the MediaWiki software.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * http://www.gnu.org/copyleft/gpl.html
 *
 * @file
 */

declare( strict_types = 1 );

namespace MediaWiki\Password;

/**
 * Represents an invalid password hash. It is represented as the empty string (i.e.,
 * a password hash with no type).
 *
 * No two invalid passwords are equal. Comparing anything to an invalid password will
 * return false.
 *
 * @since 1.24
 */
class InvalidPassword extends Password {
	public function crypt( string $plaintext ): void {
	}

	public function toString(): string {
		return '';
	}

	public function verify( string $password ): bool {
		return false;
	}

	public function needsUpdate(): bool {
		return false;
	}
}

/** @deprecated since 1.43 use MediaWiki\\Password\\InvalidPassword */
class_alias( InvalidPassword::class, 'InvalidPassword' );
